/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.time.Duration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.LoggingVmPauseMonitor;
import org.neo4j.logging.Log;
import org.neo4j.monitoring.VmPauseMonitor;
import org.neo4j.scheduler.JobScheduler;

public class VmPauseMonitorComponent
extends LifecycleAdapter {
    private final Config config;
    private final Log log;
    private final JobScheduler jobScheduler;
    private volatile VmPauseMonitor vmPauseMonitor;

    public VmPauseMonitorComponent(Config config, Log log, JobScheduler jobScheduler) {
        this.config = config;
        this.log = log;
        this.jobScheduler = jobScheduler;
    }

    public void start() {
        this.vmPauseMonitor = new VmPauseMonitor((Duration)this.config.get(GraphDatabaseSettings.vm_pause_monitor_measurement_duration), (Duration)this.config.get(GraphDatabaseSettings.vm_pause_monitor_stall_alert_threshold), (VmPauseMonitor.Monitor)new LoggingVmPauseMonitor(this.log), this.jobScheduler, vmPauseInfo -> this.log.warn("Detected VM stop-the-world pause: %s", new Object[]{vmPauseInfo}));
        this.vmPauseMonitor.start();
    }

    public void stop() {
        this.vmPauseMonitor.stop();
        this.vmPauseMonitor = null;
    }
}

