/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.internal.NativeIndexFileFilter;
import org.neo4j.logging.Logger;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class StoreFilesDiagnostics
extends NamedDiagnosticsProvider {
    private static final String FORMAT_DATE_ISO = "yyyy-MM-dd'T'HH:mm:ssZ";
    private final StorageEngineFactory storageEngineFactory;
    private final FileSystemAbstraction fs;
    private final DatabaseLayout databaseLayout;
    private final SimpleDateFormat dateFormat;

    public StoreFilesDiagnostics(StorageEngineFactory storageEngineFactory, FileSystemAbstraction fs, DatabaseLayout databaseLayout) {
        super("Store files");
        this.storageEngineFactory = storageEngineFactory;
        this.fs = fs;
        this.databaseLayout = databaseLayout;
        this.dateFormat = new SimpleDateFormat(FORMAT_DATE_ISO);
        this.dateFormat.setTimeZone(TimeZone.getDefault());
    }

    public void dump(Logger logger) {
        logger.log(StoreFilesDiagnostics.getDiskSpace(this.databaseLayout));
        logger.log("Storage files stored on file store: " + FileUtils.getFileStoreType((File)this.databaseLayout.databaseDirectory()));
        logger.log("Storage files: (filename : modification date - size)");
        MappedFileCounter mappedCounter = new MappedFileCounter();
        long totalSize = this.logStoreFiles(logger, "  ", this.databaseLayout.databaseDirectory(), mappedCounter);
        logger.log("Storage summary: ");
        logger.log("  Total size of store: " + ByteUnit.bytesToString((long)totalSize));
        logger.log("  Total size of mapped files: " + ByteUnit.bytesToString((long)mappedCounter.getSize()));
    }

    private long logStoreFiles(Logger logger, String prefix, File dir, MappedFileCounter mappedCounter) {
        if (!dir.isDirectory()) {
            return 0L;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            logger.log(prefix + "<INACCESSIBLE>");
            return 0L;
        }
        long total = 0L;
        List<File> fileList = Arrays.asList(files);
        fileList.sort(Comparator.comparing(File::getName));
        for (File file : fileList) {
            long size;
            String filename = file.getName();
            if (file.isDirectory()) {
                logger.log(prefix + filename + ":");
                size = this.logStoreFiles(logger, prefix + "  ", file, mappedCounter);
                filename = "- Total";
            } else {
                size = file.length();
                mappedCounter.addFile(file);
            }
            String fileModificationDate = this.getFileModificationDate(file);
            String bytes = ByteUnit.bytesToString((long)size);
            String fileInformation = String.format("%s%s: %s - %s", prefix, filename, fileModificationDate, bytes);
            logger.log(fileInformation);
            total += size;
        }
        return total;
    }

    private String getFileModificationDate(File file) {
        Date modifiedDate = new Date(file.lastModified());
        return this.dateFormat.format(modifiedDate);
    }

    private static String getDiskSpace(DatabaseLayout databaseLayout) {
        File directory = databaseLayout.databaseDirectory();
        long free = directory.getFreeSpace();
        long total = directory.getTotalSpace();
        long percentage = total != 0L ? free * 100L / total : 0L;
        return String.format("Disk space on partition (Total / Free / Free %%): %s / %s / %s", total, free, percentage);
    }

    private class MappedFileCounter {
        private final List<File> mappedCandidates = new ArrayList<File>();
        private long size;
        private final FileFilter mappedIndexFilter;

        MappedFileCounter() {
            try {
                this.mappedCandidates.addAll(StoreFilesDiagnostics.this.storageEngineFactory.listStorageFiles(StoreFilesDiagnostics.this.fs, StoreFilesDiagnostics.this.databaseLayout));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mappedIndexFilter = new NativeIndexFileFilter(StoreFilesDiagnostics.this.databaseLayout.databaseDirectory());
        }

        void addFile(File file) {
            if (this.canBeManagedByPageCache(file) || this.mappedIndexFilter.accept(file)) {
                this.size += file.length();
            }
        }

        public long getSize() {
            return this.size;
        }

        boolean canBeManagedByPageCache(File storeFile) {
            boolean isLabelScanStore = StoreFilesDiagnostics.this.databaseLayout.labelScanStore().equals(storeFile);
            return isLabelScanStore || this.mappedCandidates.contains(storeFile);
        }
    }
}

