/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.LongSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFileChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogFileCreateEvent;

class TransactionLogChannelAllocator {
    private final TransactionLogFilesContext logFilesContext;
    private final FileSystemAbstraction fileSystem;
    private final TransactionLogFilesHelper fileHelper;
    private final LogHeaderCache logHeaderCache;
    private final LogFileChannelNativeAccessor nativeChannelAccessor;
    private final DatabaseTracer databaseTracer;

    TransactionLogChannelAllocator(TransactionLogFilesContext logFilesContext, TransactionLogFilesHelper fileHelper, LogHeaderCache logHeaderCache, LogFileChannelNativeAccessor nativeChannelAccessor) {
        this.logFilesContext = logFilesContext;
        this.fileSystem = logFilesContext.getFileSystem();
        this.databaseTracer = logFilesContext.getDatabaseTracer();
        this.fileHelper = fileHelper;
        this.logHeaderCache = logHeaderCache;
        this.nativeChannelAccessor = nativeChannelAccessor;
    }

    PhysicalLogVersionedStoreChannel createLogChannel(long version, LongSupplier lastCommittedTransactionId) throws IOException {
        AllocatedFile allocatedFile = this.allocateFile(version);
        StoreChannel storeChannel = allocatedFile.getStoreChannel();
        File logFile = allocatedFile.getFile();
        ByteBuffer headerBuffer = ByteBuffers.allocate((int)64);
        LogHeader header = LogHeaderReader.readLogHeader(headerBuffer, (ReadableByteChannel)storeChannel, false, logFile);
        if (header == null) {
            try (LogFileCreateEvent ignored = this.databaseTracer.createLogFile();){
                storeChannel.position(0L);
                long lastTxId = lastCommittedTransactionId.getAsLong();
                LogHeader logHeader = new LogHeader(version, lastTxId, this.logFilesContext.getStoreId());
                LogHeaderWriter.writeLogHeader(storeChannel, logHeader);
                this.logHeaderCache.putHeader(version, logHeader);
            }
        }
        byte formatVersion = header == null ? (byte)7 : (byte)header.getLogFormatVersion();
        return new PhysicalLogVersionedStoreChannel(storeChannel, version, formatVersion, logFile, this.nativeChannelAccessor);
    }

    PhysicalLogVersionedStoreChannel openLogChannel(long version) throws IOException {
        File fileToOpen = this.fileHelper.getLogFileForVersion(version);
        if (!this.fileSystem.fileExists(fileToOpen)) {
            throw new FileNotFoundException(fileToOpen.getCanonicalPath());
        }
        StoreChannel rawChannel = null;
        try {
            rawChannel = this.fileSystem.read(fileToOpen);
            ByteBuffer buffer = ByteBuffers.allocate((int)64);
            LogHeader header = LogHeaderReader.readLogHeader(buffer, (ReadableByteChannel)rawChannel, true, fileToOpen);
            if (header == null || header.getLogVersion() != version) {
                throw new IllegalStateException(String.format("Unexpected log file header. Expected header version: %d, actual header: %s", version, header != null ? header.toString() : "null header."));
            }
            PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(rawChannel, version, header.getLogFormatVersion(), fileToOpen, this.nativeChannelAccessor);
            this.nativeChannelAccessor.adviseSequentialAccessAndKeepInCache(rawChannel, version);
            return versionedStoreChannel;
        }
        catch (FileNotFoundException cause) {
            throw (FileNotFoundException)new FileNotFoundException(fileToOpen.getCanonicalPath()).initCause(cause);
        }
        catch (Throwable unexpectedError) {
            if (rawChannel != null) {
                try {
                    rawChannel.close();
                }
                catch (IOException e) {
                    unexpectedError.addSuppressed(e);
                }
            }
            throw unexpectedError;
        }
    }

    private AllocatedFile allocateFile(long version) throws IOException {
        File file = this.fileHelper.getLogFileForVersion(version);
        boolean fileExist = this.fileSystem.fileExists(file);
        StoreChannel storeChannel = this.fileSystem.write(file);
        if (fileExist) {
            this.nativeChannelAccessor.adviseSequentialAccessAndKeepInCache(storeChannel, version);
        } else if (this.logFilesContext.getTryPreallocateTransactionLogs().get()) {
            this.nativeChannelAccessor.preallocateSpace(storeChannel, version);
        }
        return new AllocatedFile(file, storeChannel);
    }

    private static class AllocatedFile {
        private final File file;
        private final StoreChannel storeChannel;

        AllocatedFile(File file, StoreChannel storeChannel) {
            this.file = file;
            this.storeChannel = storeChannel;
        }

        public File getFile() {
            return this.file;
        }

        public StoreChannel getStoreChannel() {
            return this.storeChannel;
        }
    }
}

