/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfigProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

class FusionIndexAccessor
extends FusionIndexBase<IndexAccessor>
implements IndexAccessor {
    private final IndexDescriptor descriptor;
    private final IndexFiles indexFiles;

    FusionIndexAccessor(SlotSelector slotSelector, InstanceSelector<IndexAccessor> instanceSelector, IndexDescriptor descriptor, FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure) {
        super(slotSelector, instanceSelector);
        this.descriptor = descriptor;
        this.indexFiles = new IndexFiles.Directory(fs, directoryStructure, descriptor.getId());
    }

    public void drop() {
        this.instanceSelector.forAll(IndexAccessor::drop);
        this.indexFiles.clear();
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        LazyInstanceSelector<IndexUpdater> updaterSelector = new LazyInstanceSelector<IndexUpdater>(slot -> ((IndexAccessor)this.instanceSelector.select((IndexSlot)((Object)slot))).newUpdater(mode));
        return new FusionIndexUpdater(this.slotSelector, updaterSelector);
    }

    public void force(IOLimiter ioLimiter) {
        this.instanceSelector.forAll(accessor -> accessor.force(ioLimiter));
    }

    public void refresh() {
        this.instanceSelector.forAll(IndexAccessor::refresh);
    }

    public void close() {
        this.instanceSelector.close(IndexAccessor::close);
    }

    public IndexReader newReader() {
        LazyInstanceSelector<IndexReader> readerSelector = new LazyInstanceSelector<IndexReader>(slot -> ((IndexAccessor)this.instanceSelector.select((IndexSlot)((Object)slot))).newReader());
        return new FusionIndexReader(this.slotSelector, readerSelector, this.descriptor);
    }

    public BoundedIterable<Long> newAllEntriesReader(long fromIdInclusive, long toIdExclusive) {
        final List entries = this.instanceSelector.transform(indexAccessor -> indexAccessor.newAllEntriesReader(fromIdInclusive, toIdExclusive));
        return new BoundedIterable<Long>(){

            public long maxCount() {
                long sum = 0L;
                for (BoundedIterable entry : entries) {
                    long maxCount = entry.maxCount();
                    if (maxCount == -1L) {
                        return -1L;
                    }
                    sum += maxCount;
                }
                return sum;
            }

            public void close() throws Exception {
                FusionIndexBase.forAll(AutoCloseable::close, entries);
            }

            public Iterator<Long> iterator() {
                return Iterables.concat((Iterable)entries).iterator();
            }
        };
    }

    public ResourceIterator<File> snapshotFiles() {
        return Iterators.concatResourceIterators(this.instanceSelector.transform(IndexAccessor::snapshotFiles).iterator());
    }

    public Map<String, Value> indexConfig() {
        HashMap<String, Value> indexConfig = new HashMap<String, Value>();
        this.instanceSelector.transform(IndexConfigProvider::indexConfig).forEach(source -> IndexConfigProvider.putAllNoOverwrite((Map)indexConfig, (Map)source));
        return indexConfig;
    }

    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        for (IndexSlot slot : IndexSlot.values()) {
            ((IndexAccessor)this.instanceSelector.select(slot)).verifyDeferredConstraints(nodePropertyAccessor);
        }
    }

    public boolean isDirty() {
        return Iterables.stream(this.instanceSelector.transform(IndexAccessor::isDirty)).anyMatch(Boolean::booleanValue);
    }

    public void validateBeforeCommit(Value[] tuple) {
        ((IndexAccessor)this.instanceSelector.select(this.slotSelector.selectSlot(tuple, CATEGORY_OF))).validateBeforeCommit(tuple);
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory) {
        return FusionIndexBase.consistencyCheck(this.instanceSelector.instances.values(), reporterFactory);
    }

    public long estimateNumberOfEntries() {
        List counts = this.instanceSelector.transform(IndexAccessor::estimateNumberOfEntries);
        return counts.stream().anyMatch(count -> count == -1L) ? -1L : counts.stream().mapToLong(Long::longValue).sum();
    }
}

