/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.AbstractConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeKeyConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyUniqueConstraintCreator;

public class BaseNodeConstraintCreator
extends AbstractConstraintCreator
implements ConstraintCreator {
    protected final Label label;

    public BaseNodeConstraintCreator(InternalSchemaActions actions, String name, Label label, IndexType indexType, IndexConfig indexConfig) {
        super(actions, name, indexType, indexConfig);
        this.label = label;
        this.assertInUnterminatedTransaction();
    }

    public ConstraintCreator assertPropertyIsUnique(String propertyKey) {
        return new NodePropertyUniqueConstraintCreator(this.actions, this.name, this.label, List.of(propertyKey), this.indexType, this.indexConfig);
    }

    public ConstraintCreator assertPropertyExists(String propertyKey) {
        return new NodePropertyExistenceConstraintCreator(this.actions, this.name, this.label, List.of(propertyKey), this.indexType, this.indexConfig);
    }

    public ConstraintCreator assertPropertyIsNodeKey(String propertyKey) {
        return new NodeKeyConstraintCreator(this.actions, this.name, this.label, List.of(propertyKey), this.indexType, this.indexConfig);
    }

    public ConstraintCreator withName(String name) {
        return new BaseNodeConstraintCreator(this.actions, name, this.label, this.indexType, this.indexConfig);
    }

    public ConstraintCreator withIndexType(IndexType indexType) {
        return new BaseNodeConstraintCreator(this.actions, this.name, this.label, indexType, this.indexConfig);
    }

    public ConstraintCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        return new BaseNodeConstraintCreator(this.actions, this.name, this.label, this.indexType, IndexConfig.from(indexConfiguration));
    }
}

