/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.api.state.RelationshipStateImpl;
import org.neo4j.kernel.impl.api.state.TokenState;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSetsImpl;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class TxState
implements TransactionState,
RelationshipVisitor.Home {
    private final CollectionsFactory collectionsFactory;
    private MutableLongObjectMap<MutableLongDiffSets> labelStatesMap;
    private MutableLongObjectMap<NodeStateImpl> nodeStatesMap;
    private MutableLongObjectMap<RelationshipStateImpl> relationshipStatesMap;
    private MutableLongObjectMap<TokenState> createdLabelTokens;
    private MutableLongObjectMap<TokenState> createdPropertyKeyTokens;
    private MutableLongObjectMap<TokenState> createdRelationshipTypeTokens;
    private MutableDiffSets<IndexDescriptor> indexChanges;
    private MutableDiffSets<ConstraintDescriptor> constraintsChanges;
    private RemovalsCountingDiffSets nodes;
    private RemovalsCountingDiffSets relationships;
    private Map<IndexBackedConstraintDescriptor, IndexDescriptor> createdConstraintIndexesByConstraint;
    private Map<SchemaDescriptor, Map<ValueTuple, MutableLongDiffSets>> indexUpdates;
    private long revision;
    private long dataRevision;

    public TxState() {
        this(OnHeapCollectionsFactory.INSTANCE);
    }

    public TxState(CollectionsFactory collectionsFactory) {
        this.collectionsFactory = collectionsFactory;
    }

    public void accept(TxStateVisitor visitor) throws KernelException {
        if (this.nodes != null) {
            this.nodes.getAdded().each(arg_0 -> ((TxStateVisitor)visitor).visitCreatedNode(arg_0));
        }
        if (this.relationships != null) {
            LongIterator added = this.relationships.getAdded().longIterator();
            while (added.hasNext()) {
                long relId = added.next();
                if (this.relationshipVisit(relId, (arg_0, arg_1, arg_2, arg_3) -> ((TxStateVisitor)visitor).visitCreatedRelationship(arg_0, arg_1, arg_2, arg_3))) continue;
                throw new IllegalStateException("No RelationshipState for added relationship!");
            }
            this.relationships.getRemoved().forEach(arg_0 -> ((TxStateVisitor)visitor).visitDeletedRelationship(arg_0));
        }
        if (this.nodes != null) {
            this.nodes.getRemoved().each(arg_0 -> ((TxStateVisitor)visitor).visitDeletedNode(arg_0));
        }
        for (NodeState node : this.modifiedNodes()) {
            LongDiffSets labelDiffSets;
            if (node.hasPropertyChanges()) {
                visitor.visitNodePropertyChanges(node.getId(), node.addedProperties(), node.changedProperties(), node.removedProperties());
            }
            if ((labelDiffSets = node.labelDiffSets()).isEmpty()) continue;
            visitor.visitNodeLabelChanges(node.getId(), labelDiffSets.getAdded(), labelDiffSets.getRemoved());
        }
        for (RelationshipState rel : this.modifiedRelationships()) {
            visitor.visitRelPropertyChanges(rel.getId(), rel.addedProperties(), rel.changedProperties(), rel.removedProperties());
        }
        if (this.indexChanges != null) {
            for (IndexDescriptor indexDescriptor : this.indexChanges.getAdded()) {
                visitor.visitAddedIndex(indexDescriptor);
            }
            this.indexChanges.getRemoved().forEach(arg_0 -> ((TxStateVisitor)visitor).visitRemovedIndex(arg_0));
        }
        if (this.constraintsChanges != null) {
            for (ConstraintDescriptor added : this.constraintsChanges.getAdded()) {
                visitor.visitAddedConstraint(added);
            }
            this.constraintsChanges.getRemoved().forEach(arg_0 -> ((TxStateVisitor)visitor).visitRemovedConstraint(arg_0));
        }
        if (this.createdLabelTokens != null) {
            this.createdLabelTokens.forEachKeyValue((LongObjectProcedure & Serializable)(id, token) -> visitor.visitCreatedLabelToken(id, token.name, token.internal));
        }
        if (this.createdPropertyKeyTokens != null) {
            this.createdPropertyKeyTokens.forEachKeyValue((LongObjectProcedure & Serializable)(id, token) -> visitor.visitCreatedPropertyKeyToken(id, token.name, token.internal));
        }
        if (this.createdRelationshipTypeTokens != null) {
            this.createdRelationshipTypeTokens.forEachKeyValue((LongObjectProcedure & Serializable)(id, token) -> visitor.visitCreatedRelationshipTypeToken(id, token.name, token.internal));
        }
    }

    public boolean hasChanges() {
        return this.revision != 0L;
    }

    public boolean hasDataChanges() {
        return this.getDataRevision() != 0L;
    }

    public Iterable<NodeState> modifiedNodes() {
        return this.nodeStatesMap == null ? Iterables.empty() : Iterables.cast((Iterable)this.nodeStatesMap.values());
    }

    @VisibleForTesting
    MutableLongDiffSets getOrCreateLabelStateNodeDiffSets(long labelId) {
        if (this.labelStatesMap == null) {
            this.labelStatesMap = new LongObjectHashMap();
        }
        return (MutableLongDiffSets)this.labelStatesMap.getIfAbsentPut(labelId, (Function0 & Serializable)() -> new MutableLongDiffSetsImpl(this.collectionsFactory));
    }

    private LongDiffSets getLabelStateNodeDiffSets(long labelId) {
        if (this.labelStatesMap == null) {
            return LongDiffSets.EMPTY;
        }
        LongDiffSets nodeDiffSets = (LongDiffSets)this.labelStatesMap.get(labelId);
        return nodeDiffSets == null ? LongDiffSets.EMPTY : nodeDiffSets;
    }

    public LongDiffSets nodeStateLabelDiffSets(long nodeId) {
        return this.getNodeState(nodeId).labelDiffSets();
    }

    private MutableLongDiffSets getOrCreateNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getOrCreateLabelDiffSets();
    }

    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.isAdded(nodeId);
    }

    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.isAdded(relationshipId);
    }

    private void changed() {
        ++this.revision;
    }

    private void dataChanged() {
        this.changed();
        this.dataRevision = this.revision;
    }

    @Override
    public void nodeDoCreate(long id) {
        this.nodes().add(id);
        this.dataChanged();
    }

    @Override
    public void nodeDoDelete(long nodeId) {
        NodeStateImpl nodeState;
        this.nodes().remove(nodeId);
        if (this.nodeStatesMap != null && (nodeState = (NodeStateImpl)this.nodeStatesMap.remove(nodeId)) != null) {
            LongDiffSets diff = nodeState.labelDiffSets();
            diff.getAdded().each((LongProcedure & Serializable)label -> this.getOrCreateLabelStateNodeDiffSets(label).remove(nodeId));
            nodeState.clearIndexDiffs(nodeId);
            nodeState.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoCreate(long id, int relationshipTypeId, long startNodeId, long endNodeId) {
        this.relationships().add(id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, RelationshipDirection.LOOP);
        } else {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, RelationshipDirection.OUTGOING);
            this.getOrCreateNodeState(endNodeId).addRelationship(id, relationshipTypeId, RelationshipDirection.INCOMING);
        }
        this.getOrCreateRelationshipState(id).setMetaData(startNodeId, endNodeId, relationshipTypeId);
        this.dataChanged();
    }

    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.wasRemoved(nodeId);
    }

    @Override
    public void relationshipDoDelete(long id, int type, long startNodeId, long endNodeId) {
        RelationshipStateImpl removed;
        this.relationships().remove(id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, RelationshipDirection.LOOP);
        } else {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, RelationshipDirection.OUTGOING);
            this.getOrCreateNodeState(endNodeId).removeRelationship(id, type, RelationshipDirection.INCOMING);
        }
        if (this.relationshipStatesMap != null && (removed = (RelationshipStateImpl)this.relationshipStatesMap.remove(id)) != null) {
            removed.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoDeleteAddedInThisTx(long relationshipId) {
        this.getRelationshipState(relationshipId).accept(this::relationshipDoDelete);
    }

    public boolean relationshipIsDeletedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.wasRemoved(relationshipId);
    }

    @Override
    public void nodeDoAddProperty(long nodeId, int newPropertyKeyId, Value value) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        nodeState.addProperty(newPropertyKeyId, value);
        this.dataChanged();
    }

    @Override
    public void nodeDoChangeProperty(long nodeId, int propertyKeyId, Value newValue) {
        this.getOrCreateNodeState(nodeId).changeProperty(propertyKeyId, newValue);
        this.dataChanged();
    }

    @Override
    public void relationshipDoReplaceProperty(long relationshipId, int propertyKeyId, Value replacedValue, Value newValue) {
        if (replacedValue != Values.NO_VALUE) {
            this.getOrCreateRelationshipState(relationshipId).changeProperty(propertyKeyId, newValue);
        } else {
            this.getOrCreateRelationshipState(relationshipId).addProperty(propertyKeyId, newValue);
        }
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveProperty(long nodeId, int propertyKeyId) {
        this.getOrCreateNodeState(nodeId).removeProperty(propertyKeyId);
        this.dataChanged();
    }

    @Override
    public void relationshipDoRemoveProperty(long relationshipId, int propertyKeyId) {
        this.getOrCreateRelationshipState(relationshipId).removeProperty(propertyKeyId);
        this.dataChanged();
    }

    @Override
    public void nodeDoAddLabel(long labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).add(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).add(labelId);
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveLabel(long labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).remove(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).remove(labelId);
        this.dataChanged();
    }

    @Override
    public void labelDoCreateForName(String labelName, boolean internal, long id) {
        if (this.createdLabelTokens == null) {
            this.createdLabelTokens = new LongObjectHashMap();
        }
        this.createdLabelTokens.put(id, (Object)new TokenState(labelName, internal));
        this.changed();
    }

    @Override
    public void propertyKeyDoCreateForName(String propertyKeyName, boolean internal, int id) {
        if (this.createdPropertyKeyTokens == null) {
            this.createdPropertyKeyTokens = new LongObjectHashMap();
        }
        this.createdPropertyKeyTokens.put((long)id, (Object)new TokenState(propertyKeyName, internal));
        this.changed();
    }

    @Override
    public void relationshipTypeDoCreateForName(String labelName, boolean internal, int id) {
        if (this.createdRelationshipTypeTokens == null) {
            this.createdRelationshipTypeTokens = new LongObjectHashMap();
        }
        this.createdRelationshipTypeTokens.put((long)id, (Object)new TokenState(labelName, internal));
        this.changed();
    }

    public NodeState getNodeState(long id) {
        if (this.nodeStatesMap == null) {
            return NodeStateImpl.EMPTY;
        }
        NodeState nodeState = (NodeState)this.nodeStatesMap.get(id);
        return nodeState == null ? NodeStateImpl.EMPTY : nodeState;
    }

    public RelationshipState getRelationshipState(long id) {
        if (this.relationshipStatesMap == null) {
            return RelationshipStateImpl.EMPTY;
        }
        RelationshipStateImpl relationshipState = (RelationshipStateImpl)this.relationshipStatesMap.get(id);
        return relationshipState == null ? RelationshipStateImpl.EMPTY : relationshipState;
    }

    public MutableLongSet augmentLabels(MutableLongSet labels, NodeState nodeState) {
        LongDiffSets labelDiffSets = nodeState.labelDiffSets();
        if (!labelDiffSets.isEmpty()) {
            labelDiffSets.getRemoved().forEach(arg_0 -> ((MutableLongSet)labels).remove(arg_0));
            labelDiffSets.getAdded().forEach(arg_0 -> ((MutableLongSet)labels).add(arg_0));
        }
        return labels;
    }

    public LongDiffSets nodesWithLabelChanged(long label) {
        return this.getLabelStateNodeDiffSets(label);
    }

    @Override
    public void indexDoAdd(IndexDescriptor descriptor) {
        MutableDiffSets<IndexDescriptor> diff = this.indexChangesDiffSets();
        if (!diff.unRemove(descriptor)) {
            diff.add(descriptor);
        }
        this.changed();
    }

    @Override
    public void indexDoDrop(IndexDescriptor index) {
        this.indexChangesDiffSets().remove(index);
        this.changed();
    }

    @Override
    public boolean indexDoUnRemove(IndexDescriptor index) {
        return this.indexChangesDiffSets().unRemove(index);
    }

    public DiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        return this.indexChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel((int)labelId));
    }

    public DiffSets<IndexDescriptor> indexDiffSetsByRelationshipType(int relationshipType) {
        return this.indexChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasRelType((int)relationshipType));
    }

    public DiffSets<IndexDescriptor> indexDiffSetsBySchema(SchemaDescriptor schema) {
        return this.indexChangesDiffSets().filterAdded(indexDescriptor -> indexDescriptor.schema().equals(schema));
    }

    public DiffSets<IndexDescriptor> indexChanges() {
        return DiffSets.Empty.ifNull(this.indexChanges);
    }

    private MutableDiffSets<IndexDescriptor> indexChangesDiffSets() {
        if (this.indexChanges == null) {
            this.indexChanges = new MutableDiffSetsImpl<IndexDescriptor>();
        }
        return this.indexChanges;
    }

    public LongDiffSets addedAndRemovedNodes() {
        return this.nodes == null ? LongDiffSets.EMPTY : this.nodes;
    }

    private RemovalsCountingDiffSets nodes() {
        if (this.nodes == null) {
            this.nodes = new RemovalsCountingDiffSets();
        }
        return this.nodes;
    }

    public LongDiffSets addedAndRemovedRelationships() {
        return this.relationships == null ? LongDiffSets.EMPTY : this.relationships;
    }

    private RemovalsCountingDiffSets relationships() {
        if (this.relationships == null) {
            this.relationships = new RemovalsCountingDiffSets();
        }
        return this.relationships;
    }

    public Iterable<RelationshipState> modifiedRelationships() {
        return this.relationshipStatesMap == null ? Iterables.empty() : Iterables.cast((Iterable)this.relationshipStatesMap.values());
    }

    @VisibleForTesting
    NodeStateImpl getOrCreateNodeState(long nodeId) {
        if (this.nodeStatesMap == null) {
            this.nodeStatesMap = new LongObjectHashMap();
        }
        return (NodeStateImpl)this.nodeStatesMap.getIfAbsentPut(nodeId, (Function0 & Serializable)() -> new NodeStateImpl(nodeId, this.collectionsFactory));
    }

    private RelationshipStateImpl getOrCreateRelationshipState(long relationshipId) {
        if (this.relationshipStatesMap == null) {
            this.relationshipStatesMap = new LongObjectHashMap();
        }
        return (RelationshipStateImpl)this.relationshipStatesMap.getIfAbsentPut(relationshipId, (Function0 & Serializable)() -> new RelationshipStateImpl(relationshipId, this.collectionsFactory));
    }

    @Override
    public void constraintDoAdd(IndexBackedConstraintDescriptor constraint, IndexDescriptor index) {
        this.constraintsChangesDiffSets().add((ConstraintDescriptor)constraint);
        if (index != null && index != IndexDescriptor.NO_INDEX) {
            this.createdConstraintIndexesByConstraint().put(constraint, index);
        }
        this.changed();
    }

    @Override
    public void constraintDoAdd(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().add(constraint);
        this.changed();
    }

    public DiffSets<ConstraintDescriptor> constraintsChangesForLabel(int labelId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel((int)labelId));
    }

    public DiffSets<ConstraintDescriptor> constraintsChangesForSchema(SchemaDescriptor descriptor) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptor.equalTo((SchemaDescriptor)descriptor));
    }

    public DiffSets<ConstraintDescriptor> constraintsChangesForRelationshipType(int relTypeId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasRelType((int)relTypeId));
    }

    public DiffSets<ConstraintDescriptor> constraintsChanges() {
        return DiffSets.Empty.ifNull(this.constraintsChanges);
    }

    private MutableDiffSets<ConstraintDescriptor> constraintsChangesDiffSets() {
        if (this.constraintsChanges == null) {
            this.constraintsChanges = new MutableDiffSetsImpl<ConstraintDescriptor>();
        }
        return this.constraintsChanges;
    }

    @Override
    public void constraintDoDrop(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().remove(constraint);
        this.changed();
    }

    @Override
    public boolean constraintDoUnRemove(ConstraintDescriptor constraint) {
        return this.constraintsChangesDiffSets().unRemove(constraint);
    }

    public Iterator<IndexDescriptor> constraintIndexesCreatedInTx() {
        if (this.createdConstraintIndexesByConstraint != null && !this.createdConstraintIndexesByConstraint.isEmpty()) {
            return this.createdConstraintIndexesByConstraint.values().iterator();
        }
        return Collections.emptyIterator();
    }

    public IndexDescriptor indexCreatedForConstraint(ConstraintDescriptor constraint) {
        if (constraint.isIndexBackedConstraint()) {
            IndexBackedConstraintDescriptor indexBacked = constraint.asIndexBackedConstraint();
            return this.createdConstraintIndexesByConstraint == null ? null : this.createdConstraintIndexesByConstraint.get(indexBacked);
        }
        return IndexDescriptor.NO_INDEX;
    }

    @Nullable
    public UnmodifiableMap<ValueTuple, ? extends LongDiffSets> getIndexUpdates(SchemaDescriptor schema) {
        if (this.indexUpdates == null) {
            return null;
        }
        Map<ValueTuple, MutableLongDiffSets> updates = this.indexUpdates.get(schema);
        if (updates == null) {
            return null;
        }
        return new UnmodifiableMap(updates);
    }

    @Nullable
    public NavigableMap<ValueTuple, ? extends LongDiffSets> getSortedIndexUpdates(SchemaDescriptor descriptor) {
        TreeMap<ValueTuple, MutableLongDiffSets> sortedUpdates;
        if (this.indexUpdates == null) {
            return null;
        }
        Map<ValueTuple, MutableLongDiffSets> updates = this.indexUpdates.get(descriptor);
        if (updates == null) {
            return null;
        }
        if (updates instanceof TreeMap) {
            sortedUpdates = (TreeMap<ValueTuple, MutableLongDiffSets>)updates;
        } else {
            sortedUpdates = new TreeMap<ValueTuple, MutableLongDiffSets>(ValueTuple.COMPARATOR);
            sortedUpdates.putAll(updates);
            this.indexUpdates.put(descriptor, sortedUpdates);
        }
        return Collections.unmodifiableNavigableMap(sortedUpdates);
    }

    @Override
    public void indexDoUpdateEntry(SchemaDescriptor descriptor, long nodeId, ValueTuple propertiesBefore, ValueTuple propertiesAfter) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        Map<ValueTuple, MutableLongDiffSets> updates = this.getOrCreateIndexUpdatesByDescriptor(descriptor);
        if (propertiesBefore != null) {
            MutableLongDiffSets before = this.getOrCreateIndexUpdatesForSeek(updates, propertiesBefore);
            before.remove(nodeId);
            if (before.getRemoved().contains(nodeId)) {
                nodeState.addIndexDiff(before);
            } else {
                nodeState.removeIndexDiff(before);
            }
        }
        if (propertiesAfter != null) {
            MutableLongDiffSets after = this.getOrCreateIndexUpdatesForSeek(updates, propertiesAfter);
            after.add(nodeId);
            if (after.getAdded().contains(nodeId)) {
                nodeState.addIndexDiff(after);
            } else {
                nodeState.removeIndexDiff(after);
            }
        }
    }

    @VisibleForTesting
    MutableLongDiffSets getOrCreateIndexUpdatesForSeek(Map<ValueTuple, MutableLongDiffSets> updates, ValueTuple values) {
        return updates.computeIfAbsent(values, value -> new MutableLongDiffSetsImpl(this.collectionsFactory));
    }

    private Map<ValueTuple, MutableLongDiffSets> getOrCreateIndexUpdatesByDescriptor(SchemaDescriptor schema) {
        if (this.indexUpdates == null) {
            this.indexUpdates = new HashMap<SchemaDescriptor, Map<ValueTuple, MutableLongDiffSets>>();
        }
        return this.indexUpdates.computeIfAbsent(schema, k -> new HashMap());
    }

    private Map<IndexBackedConstraintDescriptor, IndexDescriptor> createdConstraintIndexesByConstraint() {
        if (this.createdConstraintIndexesByConstraint == null) {
            this.createdConstraintIndexesByConstraint = new HashMap<IndexBackedConstraintDescriptor, IndexDescriptor>();
        }
        return this.createdConstraintIndexesByConstraint;
    }

    public <EX extends Exception> boolean relationshipVisit(long relId, RelationshipVisitor<EX> visitor) throws EX {
        return this.getRelationshipState(relId).accept(visitor);
    }

    public long getDataRevision() {
        return this.dataRevision;
    }

    private class RemovalsCountingDiffSets
    extends MutableLongDiffSetsImpl {
        private MutableLongSet removedFromAdded;

        RemovalsCountingDiffSets() {
            super(TxState.this.collectionsFactory);
        }

        @Override
        public boolean remove(long elem) {
            if (this.isAdded(elem) && super.remove(elem)) {
                if (this.removedFromAdded == null) {
                    this.removedFromAdded = TxState.this.collectionsFactory.newLongSet();
                }
                this.removedFromAdded.add(elem);
                return true;
            }
            return super.remove(elem);
        }

        private boolean wasRemoved(long id) {
            return this.removedFromAdded != null && this.removedFromAdded.contains(id) || super.isRemoved(id);
        }
    }
}

