/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public final class IndexMap
implements Cloneable {
    private final MutableLongObjectMap<IndexProxy> indexesById;

    public IndexMap() {
        this((MutableLongObjectMap<IndexProxy>)new LongObjectHashMap());
    }

    private IndexMap(MutableLongObjectMap<IndexProxy> indexesById) {
        this.indexesById = indexesById;
    }

    public IndexProxy getIndexProxy(IndexDescriptor index) {
        return (IndexProxy)this.indexesById.get(index.getId());
    }

    public IndexProxy getIndexProxy(long indexId) {
        return (IndexProxy)this.indexesById.get(indexId);
    }

    public void putIndexProxy(IndexProxy indexProxy) {
        IndexDescriptor index = indexProxy.getDescriptor();
        this.indexesById.put(index.getId(), (Object)indexProxy);
    }

    IndexProxy removeIndexProxy(long indexId) {
        return (IndexProxy)this.indexesById.remove(indexId);
    }

    void forEachIndexProxy(LongObjectProcedure<IndexProxy> consumer) {
        this.indexesById.forEachKeyValue(consumer);
    }

    Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexesById.values();
    }

    public IndexMap clone() {
        return new IndexMap((MutableLongObjectMap<IndexProxy>)LongObjectHashMap.newMap(this.indexesById));
    }

    public LongIterator indexIds() {
        return this.indexesById.keySet().longIterator();
    }

    public int size() {
        return this.indexesById.size();
    }
}

