/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.ResourceCloseFailureException;

public class CloseableResourceManager
implements ResourceTracker {
    private Collection<AutoCloseable> closeableResources;

    public final void registerCloseableResource(AutoCloseable closeable) {
        if (this.closeableResources == null) {
            this.closeableResources = new ArrayList<AutoCloseable>(8);
        }
        this.closeableResources.add(closeable);
    }

    public final void unregisterCloseableResource(AutoCloseable closeable) {
        if (this.closeableResources != null) {
            this.closeableResources.remove(closeable);
        }
    }

    public final void closeAllCloseableResources() {
        if (this.closeableResources != null) {
            Collection<AutoCloseable> resourcesToClose = this.closeableResources;
            this.closeableResources = null;
            IOUtils.close(ResourceCloseFailureException::new, (AutoCloseable[])resourcesToClose.toArray(new AutoCloseable[0]));
        }
    }
}

