/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

class QueryObfuscation {
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("(?:(?i)call)\\s+(?:dbms(?:\\.security)?\\.change(?:User)?Password|dbms\\.security\\.createUser)\\(\\s*(?:\\s*(?:'(?:(?<=\\\\)'|[^'])*'|\"(?:(?<=\\\\)\"|[^\"])*\"|[^,]*)\\s*,)?\\s*('(?:(?<=\\\\)'|[^'])*'|\"(?:(?<=\\\\)\"|[^\"])*\"|\\$\\w*|\\{\\w*})");
    private static final TextValue OBFUSCATED = Values.stringValue((String)"******");
    private static final String OBFUSCATED_LITERAL = "'******'";
    private static final Pattern SYSTEM_PASSWORD_PATTERN = Pattern.compile("^(?:(?:ALTER|CREATE)\\s+(?:CURRENT\\s+)?(?:OR\\s+REPLACE\\s+)?USER\\s+(?:(?:`)?\\w+(?:`)?\\s+)?(?:IF\\s+NOT\\s+EXISTS\\s+)?SET\\s+PASSWORD\\s+)(?:FROM\\s+)?((?:\\$\\w+)|(?:\"[^\"]*\")|(?:'[^']*'))(?:\\s+TO\\s+)?((?:\\$\\w+)|(?:\"[^\"]*\")|(?:'[^']*'))?", 2);

    QueryObfuscation() {
    }

    static String obfuscateText(String queryText, Set<String> passwordParams) {
        Matcher matcher = PASSWORD_PATTERN.matcher(queryText);
        while (matcher.find()) {
            String password = matcher.group(1).trim();
            if (password.charAt(0) == '$') {
                passwordParams.add(password.substring(1));
                continue;
            }
            queryText = queryText.replace(password, OBFUSCATED_LITERAL);
        }
        return queryText;
    }

    static String obfuscateSystemCommand(String queryText, Set<String> passwordParams) {
        Matcher matcher = SYSTEM_PASSWORD_PATTERN.matcher(queryText);
        while (matcher.find()) {
            String toPassword;
            String password = matcher.group(1).trim();
            if (password.charAt(0) == '$') {
                passwordParams.add(password.substring(1));
            } else {
                queryText = queryText.replace(password, OBFUSCATED_LITERAL);
            }
            if ((toPassword = matcher.group(2)) == null) continue;
            if (toPassword.charAt(0) == '$') {
                passwordParams.add(toPassword.substring(1));
                continue;
            }
            queryText = queryText.replace(toPassword, OBFUSCATED_LITERAL);
        }
        return queryText;
    }

    static MapValue obfuscateParams(MapValue queryParameters, Set<String> passwordParams) {
        for (String passwordKey : passwordParams) {
            queryParameters = queryParameters.updatedWith(passwordKey, (AnyValue)OBFUSCATED);
        }
        return queryParameters;
    }
}

