/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.api.TransactionIdStore;

public class LogFilesBuilder {
    private boolean readOnly;
    private PageCache pageCache;
    private DatabaseLayout databaseLayout;
    private File logsDirectory;
    private Config config;
    private Long rotationThreshold;
    private LogEntryReader logEntryReader;
    private LogProvider logProvider = NullLogProvider.getInstance();
    private DependencyResolver dependencies;
    private FileSystemAbstraction fileSystem;
    private LogVersionRepository logVersionRepository;
    private TransactionIdStore transactionIdStore;
    private LongSupplier lastCommittedTransactionIdSupplier;
    private Supplier<LogPosition> lastClosedPositionSupplier;
    private String logFileName = "neostore.transaction.db";
    private boolean fileBasedOperationsOnly;
    private DatabaseTracer databaseTracer = DatabaseTracer.NULL;
    private StoreId storeId;
    private NativeAccess nativeAccess;

    private LogFilesBuilder() {
    }

    public static LogFilesBuilder builder(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem) {
        LogFilesBuilder filesBuilder = new LogFilesBuilder();
        filesBuilder.databaseLayout = databaseLayout;
        filesBuilder.fileSystem = fileSystem;
        return filesBuilder;
    }

    public static LogFilesBuilder activeFilesBuilder(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCache pageCache) {
        LogFilesBuilder builder = LogFilesBuilder.builder(databaseLayout, fileSystem);
        builder.pageCache = pageCache;
        builder.readOnly = true;
        return builder;
    }

    public static LogFilesBuilder logFilesBasedOnlyBuilder(File logsDirectory, FileSystemAbstraction fileSystem) {
        LogFilesBuilder builder = new LogFilesBuilder();
        builder.logsDirectory = logsDirectory;
        builder.fileSystem = fileSystem;
        builder.fileBasedOperationsOnly = true;
        return builder;
    }

    LogFilesBuilder withLogFileName(String name) {
        this.logFileName = name;
        return this;
    }

    public LogFilesBuilder withLastClosedTransactionPositionSupplier(Supplier<LogPosition> lastClosedPositionSupplier) {
        this.lastClosedPositionSupplier = lastClosedPositionSupplier;
        return this;
    }

    public LogFilesBuilder withLogVersionRepository(LogVersionRepository logVersionRepository) {
        this.logVersionRepository = logVersionRepository;
        return this;
    }

    public LogFilesBuilder withTransactionIdStore(TransactionIdStore transactionIdStore) {
        this.transactionIdStore = transactionIdStore;
        return this;
    }

    public LogFilesBuilder withLogProvider(LogProvider logProvider) {
        this.logProvider = logProvider;
        return this;
    }

    public LogFilesBuilder withLastCommittedTransactionIdSupplier(LongSupplier transactionIdSupplier) {
        this.lastCommittedTransactionIdSupplier = transactionIdSupplier;
        return this;
    }

    public LogFilesBuilder withLogEntryReader(LogEntryReader logEntryReader) {
        this.logEntryReader = logEntryReader;
        return this;
    }

    public LogFilesBuilder withConfig(Config config) {
        this.config = config;
        return this;
    }

    public LogFilesBuilder withRotationThreshold(long rotationThreshold) {
        this.rotationThreshold = rotationThreshold;
        return this;
    }

    public LogFilesBuilder withDependencies(DependencyResolver dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public LogFilesBuilder withDatabaseTracer(DatabaseTracer databaseTracer) {
        this.databaseTracer = databaseTracer;
        return this;
    }

    public LogFilesBuilder withNativeAccess(NativeAccess nativeAccess) {
        this.nativeAccess = nativeAccess;
        return this;
    }

    public LogFilesBuilder withStoreId(StoreId storeId) {
        this.storeId = storeId;
        return this;
    }

    public LogFilesBuilder withLogsDirectory(File logsDirectory) {
        this.logsDirectory = logsDirectory;
        return this;
    }

    public LogFiles build() throws IOException {
        TransactionLogFilesContext filesContext = this.buildContext();
        File logsDirectory = this.getLogsDirectory();
        filesContext.getFileSystem().mkdirs(logsDirectory);
        return new TransactionLogFiles(logsDirectory, this.logFileName, filesContext);
    }

    private File getLogsDirectory() {
        if (this.logsDirectory != null) {
            return this.logsDirectory;
        }
        return this.databaseLayout.getTransactionLogsDirectory();
    }

    TransactionLogFilesContext buildContext() throws IOException {
        if (this.logEntryReader == null) {
            this.logEntryReader = new VersionAwareLogEntryReader();
        }
        if (this.config == null) {
            this.config = Config.defaults();
        }
        Objects.requireNonNull(this.fileSystem);
        Supplier<StoreId> storeIdSupplier = this.getStoreId();
        Supplier<LogVersionRepository> logVersionRepositorySupplier = this.getLogVersionRepositorySupplier();
        LongSupplier lastCommittedIdSupplier = this.lastCommittedIdSupplier();
        LongSupplier committingTransactionIdSupplier = this.committingIdSupplier();
        Supplier<LogPosition> lastClosedTransactionPositionSupplier = this.closePositionSupplier();
        AtomicLong rotationThreshold = this.getRotationThresholdAndRegisterForUpdates();
        AtomicBoolean tryPreallocateTransactionLogs = this.getTryToPreallocateTransactionLogs();
        NativeAccess nativeAccess = this.getNativeAccess();
        return new TransactionLogFilesContext(rotationThreshold, tryPreallocateTransactionLogs, this.logEntryReader, lastCommittedIdSupplier, committingTransactionIdSupplier, lastClosedTransactionPositionSupplier, logVersionRepositorySupplier, this.fileSystem, this.logProvider, this.databaseTracer, storeIdSupplier, nativeAccess);
    }

    private NativeAccess getNativeAccess() {
        if (this.nativeAccess != null) {
            return this.nativeAccess;
        }
        return NativeAccessProvider.getNativeAccess();
    }

    private AtomicLong getRotationThresholdAndRegisterForUpdates() {
        if (this.rotationThreshold != null) {
            return new AtomicLong(this.rotationThreshold);
        }
        if (this.readOnly) {
            return new AtomicLong(Long.MAX_VALUE);
        }
        AtomicLong configThreshold = new AtomicLong((Long)this.config.get(GraphDatabaseSettings.logical_log_rotation_threshold));
        this.config.addListener(GraphDatabaseSettings.logical_log_rotation_threshold, (prev, update) -> configThreshold.set((long)update));
        return configThreshold;
    }

    private AtomicBoolean getTryToPreallocateTransactionLogs() {
        if (this.readOnly) {
            return new AtomicBoolean(false);
        }
        AtomicBoolean tryToPreallocate = new AtomicBoolean((Boolean)this.config.get(GraphDatabaseSettings.preallocate_logical_logs));
        this.config.addListener(GraphDatabaseSettings.preallocate_logical_logs, (prev, update) -> {
            String logMessage = "Updating " + GraphDatabaseSettings.preallocate_logical_logs.name() + " from " + prev + " to " + update;
            this.logProvider.getLog(LogFiles.class).debug(logMessage);
            tryToPreallocate.set((boolean)update);
        });
        return tryToPreallocate;
    }

    private Supplier<LogVersionRepository> getLogVersionRepositorySupplier() throws IOException {
        if (this.logVersionRepository != null) {
            return () -> this.logVersionRepository;
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of log version repository. Please build full version of log files. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnly) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read current log version.");
            Objects.requireNonNull(this.databaseLayout, "Store directory is required.");
            LogVersionRepository logVersionRepository = this.readOnlyLogVersionRepository();
            return () -> logVersionRepository;
        }
        Objects.requireNonNull(this.dependencies, LogVersionRepository.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return this.dependencies.provideDependency(LogVersionRepository.class);
    }

    private LongSupplier lastCommittedIdSupplier() throws IOException {
        if (this.lastCommittedTransactionIdSupplier != null) {
            return this.lastCommittedTransactionIdSupplier;
        }
        if (this.transactionIdStore != null) {
            return () -> ((TransactionIdStore)this.transactionIdStore).getLastCommittedTransactionId();
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of transaction id store. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnly) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read committed transaction info from store store.");
            Objects.requireNonNull(this.databaseLayout, "Store directory is required.");
            TransactionIdStore transactionIdStore = this.readOnlyTransactionIdStore();
            return () -> ((TransactionIdStore)transactionIdStore).getLastCommittedTransactionId();
        }
        Objects.requireNonNull(this.dependencies, TransactionIdStore.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return () -> this.resolveDependency(TransactionIdStore.class).getLastCommittedTransactionId();
    }

    private Supplier<LogPosition> closePositionSupplier() throws IOException {
        if (this.lastClosedPositionSupplier != null) {
            return this.lastClosedPositionSupplier;
        }
        if (this.transactionIdStore != null) {
            return () -> {
                long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
                return new LogPosition(lastClosedTransaction[1], lastClosedTransaction[2]);
            };
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of transaction id store. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnly) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read committed transaction info from store store.");
            Objects.requireNonNull(this.databaseLayout, "Store directory is required.");
            TransactionIdStore transactionIdStore = this.readOnlyTransactionIdStore();
            return () -> {
                long[] lastClosedTransaction = transactionIdStore.getLastClosedTransaction();
                return new LogPosition(lastClosedTransaction[1], lastClosedTransaction[2]);
            };
        }
        Objects.requireNonNull(this.dependencies, TransactionIdStore.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return () -> {
            long[] lastClosedTransaction = this.resolveDependency(TransactionIdStore.class).getLastClosedTransaction();
            return new LogPosition(lastClosedTransaction[1], lastClosedTransaction[2]);
        };
    }

    private LongSupplier committingIdSupplier() throws IOException {
        if (this.transactionIdStore != null) {
            return () -> ((TransactionIdStore)this.transactionIdStore).committingTransactionId();
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of transaction id store. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnly) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read committed transaction info from store store.");
            Objects.requireNonNull(this.databaseLayout, "Store directory is required.");
            TransactionIdStore transactionIdStore = this.readOnlyTransactionIdStore();
            return () -> ((TransactionIdStore)transactionIdStore).committingTransactionId();
        }
        Objects.requireNonNull(this.dependencies, TransactionIdStore.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return () -> this.resolveDependency(TransactionIdStore.class).committingTransactionId();
    }

    private Supplier<StoreId> getStoreId() {
        if (this.storeId != null) {
            return () -> this.storeId;
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of store id. Please build full version of log files to be able to use them.");
            };
        }
        return () -> this.resolveDependency(StoreIdProvider.class).getStoreId();
    }

    private TransactionIdStore readOnlyTransactionIdStore() throws IOException {
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine();
        return storageEngineFactory.readOnlyTransactionIdStore(this.fileSystem, this.databaseLayout, this.pageCache);
    }

    private LogVersionRepository readOnlyLogVersionRepository() throws IOException {
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine();
        return storageEngineFactory.readOnlyLogVersionRepository(this.databaseLayout, this.pageCache);
    }

    private <T> T resolveDependency(Class<T> clazz) {
        return (T)this.dependencies.resolveDependency(clazz);
    }
}

