/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ThreadLink;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitment;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvents;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.SerializeTransactionEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.util.VisibleForTesting;

public class BatchingTransactionAppender
extends LifecycleAdapter
implements TransactionAppender {
    private final AtomicReference<ThreadLink> threadLinkHead = new AtomicReference<ThreadLink>(ThreadLink.END);
    private final TransactionMetadataCache transactionMetadataCache;
    private final LogFile logFile;
    private final LogRotation logRotation;
    private final TransactionIdStore transactionIdStore;
    private final LogPositionMarker positionMarker = new LogPositionMarker();
    private final Health databaseHealth;
    private final Lock forceLock = new ReentrantLock();
    private FlushablePositionAwareChecksumChannel writer;
    private TransactionLogWriter transactionLogWriter;
    private int previousChecksum;

    public BatchingTransactionAppender(LogFiles logFiles, LogRotation logRotation, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, Health databaseHealth) {
        this.logFile = logFiles.getLogFile();
        this.logRotation = logRotation;
        this.transactionIdStore = transactionIdStore;
        this.databaseHealth = databaseHealth;
        this.transactionMetadataCache = transactionMetadataCache;
        this.previousChecksum = transactionIdStore.getLastCommittedTransaction().checksum();
    }

    @VisibleForTesting
    public BatchingTransactionAppender(LogFiles logFiles, LogRotation logRotation, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, Health databaseHealth, int previousChecksum) {
        this.logFile = logFiles.getLogFile();
        this.logRotation = logRotation;
        this.transactionIdStore = transactionIdStore;
        this.databaseHealth = databaseHealth;
        this.transactionMetadataCache = transactionMetadataCache;
        this.previousChecksum = previousChecksum;
    }

    public void start() {
        this.writer = this.logFile.getWriter();
        this.transactionLogWriter = new TransactionLogWriter(new LogEntryWriter((WritableChecksumChannel)this.writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(TransactionToApply batch, LogAppendEvent logAppendEvent) throws IOException {
        long lastTransactionId = 1L;
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.databaseHealth.assertHealthy(IOException.class);
            try (SerializeTransactionEvent serialiseEvent = logAppendEvent.beginSerializeTransaction();){
                for (TransactionToApply tx = batch; tx != null; tx = tx.next()) {
                    long transactionId = this.transactionIdStore.nextCommittingTransactionId();
                    this.matchAgainstExpectedTransactionIdIfAny(transactionId, tx);
                    TransactionCommitment commitment = this.appendToLog(tx.transactionRepresentation(), transactionId, logAppendEvent, this.previousChecksum);
                    this.previousChecksum = commitment.getTransactionChecksum();
                    tx.commitment(commitment, transactionId);
                    tx.logPosition(commitment.logPosition());
                    lastTransactionId = transactionId;
                }
            }
        }
        if (this.forceAfterAppend(logAppendEvent)) {
            boolean logRotated = this.logRotation.rotateLogIfNeeded(logAppendEvent);
            logAppendEvent.setLogRotated(logRotated);
        }
        this.publishAsCommitted(batch);
        return lastTransactionId;
    }

    private void matchAgainstExpectedTransactionIdIfAny(long transactionId, TransactionToApply tx) {
        long expectedTransactionId = tx.transactionId();
        if (expectedTransactionId != 0L && transactionId != expectedTransactionId) {
            IllegalStateException ex = new IllegalStateException("Received " + tx.transactionRepresentation() + " with txId:" + expectedTransactionId + " to be applied, but appending it ended up generating an unexpected txId:" + transactionId);
            this.databaseHealth.panic((Throwable)ex);
            throw ex;
        }
    }

    private void publishAsCommitted(TransactionToApply batch) {
        while (batch != null) {
            batch.commitment().publishAsCommitted();
            batch = batch.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPoint(LogPosition logPosition, LogCheckPointEvent logCheckPointEvent) throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            try {
                LogPosition logPositionBeforeCheckpoint = this.writer.getCurrentPosition(this.positionMarker).newPosition();
                this.transactionLogWriter.checkPoint(logPosition);
                LogPosition logPositionAfterCheckpoint = this.writer.getCurrentPosition(this.positionMarker).newPosition();
                logCheckPointEvent.appendToLogFile(logPositionBeforeCheckpoint, logPositionAfterCheckpoint);
            }
            catch (Throwable cause) {
                this.databaseHealth.panic(cause);
                throw cause;
            }
        }
        this.forceAfterAppend(logCheckPointEvent);
    }

    private TransactionCommitment appendToLog(TransactionRepresentation transaction, long transactionId, LogAppendEvent logAppendEvent, int previousChecksum) throws IOException {
        try {
            LogPosition logPositionBeforeCommit = this.writer.getCurrentPosition(this.positionMarker).newPosition();
            int checksum = this.transactionLogWriter.append(transaction, transactionId, previousChecksum);
            LogPosition logPositionAfterCommit = this.writer.getCurrentPosition(this.positionMarker).newPosition();
            logAppendEvent.appendToLogFile(logPositionBeforeCommit, logPositionAfterCommit);
            this.transactionMetadataCache.cacheTransactionMetadata(transactionId, logPositionBeforeCommit, checksum, transaction.getTimeCommitted());
            return new TransactionCommitment(transactionId, checksum, transaction.getTimeCommitted(), logPositionAfterCommit, this.transactionIdStore);
        }
        catch (Throwable panic) {
            this.databaseHealth.panic(panic);
            throw panic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean forceAfterAppend(LogForceEvents logForceEvents) throws IOException {
        ThreadLink threadLink = new ThreadLink(Thread.currentThread());
        threadLink.next = this.threadLinkHead.getAndSet(threadLink);
        boolean attemptedForce = false;
        try (LogForceWaitEvent logForceWaitEvent = logForceEvents.beginLogForceWait();){
            do {
                if (this.forceLock.tryLock()) {
                    attemptedForce = true;
                    try {
                        this.forceLog(logForceEvents);
                    }
                    finally {
                        this.forceLock.unlock();
                        ThreadLink nextWaiter = this.threadLinkHead.get();
                        nextWaiter.unpark();
                    }
                } else {
                    this.waitForLogForce();
                }
            } while (!threadLink.done);
            if (!attemptedForce) {
                this.databaseHealth.assertHealthy(IOException.class);
            }
        }
        return attemptedForce;
    }

    private void forceLog(LogForceEvents logForceEvents) throws IOException {
        ThreadLink links = this.threadLinkHead.getAndSet(ThreadLink.END);
        try (LogForceEvent logForceEvent = logForceEvents.beginLogForce();){
            this.force();
        }
        catch (Throwable panic) {
            this.databaseHealth.panic(panic);
            throw panic;
        }
        finally {
            this.unparkAll(links);
        }
    }

    private void unparkAll(ThreadLink links) {
        ThreadLink tmp;
        do {
            links.done = true;
            links.unpark();
            while ((tmp = links.next) == null) {
            }
        } while ((links = tmp) != ThreadLink.END);
    }

    private void waitForLogForce() {
        long parkTime = TimeUnit.MILLISECONDS.toNanos(100L);
        LockSupport.parkNanos(this, parkTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void force() throws IOException {
        Flushable flushable;
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.databaseHealth.assertHealthy(IOException.class);
            flushable = this.writer.prepareForFlush();
        }
        try {
            flushable.flush();
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }
}

