/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.File;
import java.io.IOException;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.logging.Logger;

public class TransactionRangeDiagnostics
extends NamedDiagnosticsProvider {
    private final Database database;

    TransactionRangeDiagnostics(Database database) {
        super("Transaction log");
        this.database = database;
    }

    public void dump(Logger logger) {
        LogFiles logFiles = (LogFiles)this.database.getDependencyResolver().resolveDependency(LogFiles.class);
        try {
            logger.log("Transaction log files stored on file store: " + FileUtils.getFileStoreType((File)logFiles.logFilesDirectory()));
            long logVersion = logFiles.getLowestLogVersion();
            while (logFiles.versionExists(logVersion)) {
                if (logFiles.hasAnyEntries(logVersion)) {
                    LogHeader header = logFiles.extractHeader(logVersion);
                    long firstTransactionIdInThisLog = header.getLastCommittedTxId() + 1L;
                    logger.log("Oldest transaction " + firstTransactionIdInThisLog + " found in log with version " + logVersion);
                    return;
                }
                ++logVersion;
            }
            logger.log("No transactions found in any log");
        }
        catch (IOException e) {
            logger.log("Error trying to dump transaction log files info.", (Throwable)e);
        }
    }
}

