/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class DefaultValueMapper
extends ValueMapper.JavaMapper {
    private final InternalTransaction transaction;

    public DefaultValueMapper(InternalTransaction transaction) {
        this.transaction = transaction;
    }

    public Node mapNode(VirtualNodeValue value) {
        if (value instanceof NodeEntityWrappingNodeValue) {
            return ((NodeEntityWrappingNodeValue)value).nodeEntity();
        }
        return new NodeEntity(this.transaction, value.id());
    }

    public Relationship mapRelationship(VirtualRelationshipValue value) {
        if (value instanceof RelationshipEntityWrappingValue) {
            return ((RelationshipEntityWrappingValue)value).relationshipEntity();
        }
        return new RelationshipEntity(this.transaction, value.id());
    }

    public Path mapPath(PathValue value) {
        if (value instanceof PathWrappingPathValue) {
            return ((PathWrappingPathValue)value).path();
        }
        return new CoreAPIPath(value);
    }

    private static <U, V> Iterable<V> asList(final U[] values, final Function<U, V> mapper) {
        return () -> new Iterator<V>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < values.length;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return mapper.apply(values[this.index++]);
            }
        };
    }

    private static <U, V> Iterable<V> asReverseList(final U[] values, final Function<U, V> mapper) {
        return () -> new Iterator<V>(){
            private int index;
            {
                this.index = values.length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return mapper.apply(values[this.index--]);
            }
        };
    }

    private class CoreAPIPath
    implements Path {
        private final PathValue value;

        CoreAPIPath(PathValue value) {
            this.value = value;
        }

        public String toString() {
            return Paths.defaultPathToStringWithNotInTransactionFallback((Path)this);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CoreAPIPath) {
                return this.value.equals((VirtualValue)((CoreAPIPath)obj).value);
            }
            if (obj instanceof Path) {
                Path other = (Path)obj;
                if (this.value.nodes()[0].id() != other.startNode().getId()) {
                    return false;
                }
                return Iterators.iteratorsEqual(this.relationships().iterator(), other.relationships().iterator());
            }
            return false;
        }

        public Node startNode() {
            return DefaultValueMapper.this.mapNode((VirtualNodeValue)this.value.startNode());
        }

        public Node endNode() {
            return DefaultValueMapper.this.mapNode((VirtualNodeValue)this.value.endNode());
        }

        public Relationship lastRelationship() {
            if (this.value.size() == 0) {
                return null;
            }
            return DefaultValueMapper.this.mapRelationship((VirtualRelationshipValue)this.value.lastRelationship());
        }

        public Iterable<Relationship> relationships() {
            return DefaultValueMapper.asList(this.value.relationships(), DefaultValueMapper.this::mapRelationship);
        }

        public Iterable<Relationship> reverseRelationships() {
            return DefaultValueMapper.asReverseList(this.value.relationships(), DefaultValueMapper.this::mapRelationship);
        }

        public Iterable<Node> nodes() {
            return DefaultValueMapper.asList(this.value.nodes(), DefaultValueMapper.this::mapNode);
        }

        public Iterable<Node> reverseNodes() {
            return DefaultValueMapper.asReverseList(this.value.nodes(), DefaultValueMapper.this::mapNode);
        }

        public int length() {
            return this.value.size();
        }

        public Iterator<Entity> iterator() {
            return new Iterator<Entity>(){
                private final int size;
                private int index;
                private final NodeValue[] nodes;
                private final RelationshipValue[] relationships;
                {
                    this.size = 2 * CoreAPIPath.this.value.size() + 1;
                    this.nodes = CoreAPIPath.this.value.nodes();
                    this.relationships = CoreAPIPath.this.value.relationships();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.size;
                }

                @Override
                public Entity next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object entity = (this.index & 1) == 0 ? DefaultValueMapper.this.mapNode((VirtualNodeValue)this.nodes[this.index >> 1]) : DefaultValueMapper.this.mapRelationship((VirtualRelationshipValue)this.relationships[this.index >> 1]);
                    ++this.index;
                    return entity;
                }
            };
        }
    }
}

