/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.txstate.LongDiffSets;

class DefaultNodeLabelIndexCursor
extends IndexCursor<IndexProgressor>
implements NodeLabelIndexCursor {
    private Read read;
    private long node;
    private LabelSet labels;
    private LongIterator added;
    private LongSet removed;
    private final CursorPool<DefaultNodeLabelIndexCursor> pool;

    DefaultNodeLabelIndexCursor(CursorPool<DefaultNodeLabelIndexCursor> pool) {
        this.pool = pool;
        this.node = -1L;
    }

    public void scan(IndexProgressor progressor, int label) {
        super.initialize(progressor);
        if (this.read.hasTxStateWithChanges()) {
            LongDiffSets changes = this.read.txState().nodesWithLabelChanged(label);
            this.added = changes.augment((LongIterator)ImmutableEmptyLongIterator.INSTANCE);
            this.removed = PrimitiveLongCollections.mergeToSet((LongIterable)this.read.txState().addedAndRemovedNodes().getRemoved(), (LongIterable)changes.getRemoved());
        }
        if (this.tracer != null) {
            this.tracer.onLabelScan(label);
        }
    }

    public void scan(IndexProgressor progressor, LongIterator added, LongSet removed) {
        super.initialize(progressor);
        this.added = added;
        this.removed = removed;
    }

    IndexProgressor.NodeLabelClient nodeLabelClient() {
        return (reference, labels) -> {
            if (this.isRemoved(reference)) {
                return false;
            }
            this.node = reference;
            this.labels = labels;
            return true;
        };
    }

    public boolean next() {
        if (this.added != null && this.added.hasNext()) {
            this.node = this.added.next();
            if (this.tracer != null) {
                this.tracer.onNode(this.node);
            }
            return true;
        }
        boolean hasNext = this.innerNext();
        if (this.tracer != null && hasNext) {
            this.tracer.onNode(this.node);
        }
        return hasNext;
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    public float score() {
        return Float.NaN;
    }

    public LabelSet labels() {
        return this.labels;
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.node = -1L;
            this.labels = null;
            this.read = null;
            this.removed = null;
            this.pool.accept(this);
        }
    }

    public boolean isClosed() {
        return this.isProgressorClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeLabelIndexCursor[closed state]";
        }
        return "NodeLabelIndexCursor[node=" + this.node + ", labels= " + this.labels + ", underlying record=" + super.toString() + "]";
    }

    private boolean isRemoved(long reference) {
        return this.removed != null && this.removed.contains(reference);
    }

    public void release() {
    }
}

