/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapNumberArray;

abstract class OffHeapRegularNumberArray<N extends NumberArray<N>>
extends OffHeapNumberArray<N> {
    protected final int shift;

    protected OffHeapRegularNumberArray(long length, int shift, long base, MemoryAllocationTracker allocationTracker) {
        super(length, 1 << shift, base, allocationTracker);
        this.shift = shift;
    }

    protected long addressOf(long index) {
        if ((index = this.rebase(index)) < 0L || index >= this.length) {
            throw new ArrayIndexOutOfBoundsException("Requested index " + index + ", but length is " + this.length);
        }
        return this.address + (index << this.shift);
    }

    protected boolean isByteUniform(long value) {
        byte any = (byte)value;
        for (int i = 1; i < this.itemSize; ++i) {
            byte test = (byte)(value >>> (i << 3));
            if (test == any) continue;
            return false;
        }
        return true;
    }
}

