/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;

public class TokenHolders
implements TokenNameLookup {
    private final TokenHolder propertyKeyTokens;
    private final TokenHolder labelTokens;
    private final TokenHolder relationshipTypeTokens;

    public TokenHolders(TokenHolder propertyKeyTokens, TokenHolder labelTokens, TokenHolder relationshipTypeTokens) {
        this.propertyKeyTokens = propertyKeyTokens;
        this.labelTokens = labelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
    }

    public TokenHolder propertyKeyTokens() {
        return this.propertyKeyTokens;
    }

    public TokenHolder labelTokens() {
        return this.labelTokens;
    }

    public TokenHolder relationshipTypeTokens() {
        return this.relationshipTypeTokens;
    }

    public String labelGetName(int labelId) {
        return this.getNameById(this.labelTokens, labelId);
    }

    public String relationshipTypeGetName(int relationshipTypeId) {
        return this.getNameById(this.relationshipTypeTokens, relationshipTypeId);
    }

    public String propertyKeyGetName(int propertyKeyId) {
        return this.getNameById(this.propertyKeyTokens, propertyKeyId);
    }

    private String getNameById(TokenHolder tokenHolder, int tokenId) {
        try {
            return tokenHolder.getTokenById(tokenId).name();
        }
        catch (TokenNotFoundException e) {
            return String.format("<unknown name>[%d]", tokenId);
        }
    }
}

