/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.logging.Log;

public class LoggingLogFileMonitor
implements LogFileCreationMonitor,
LogRotation.Monitor,
RecoveryMonitor,
RecoveryStartInformationProvider.Monitor {
    private long firstTransactionRecovered = -1L;
    private long lastTransactionRecovered;
    private final Log log;

    public LoggingLogFileMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void recoveryRequired(LogPosition startPosition) {
        this.log.info("Recovery required from position " + startPosition);
    }

    @Override
    public void recoveryCompleted(int numberOfRecoveredTransactions) {
        if (numberOfRecoveredTransactions != 0) {
            this.log.info(String.format("Recovery completed. %d transactions, first:%d, last:%d recovered", numberOfRecoveredTransactions, this.firstTransactionRecovered, this.lastTransactionRecovered));
        } else {
            this.log.info("No recovery required");
        }
    }

    @Override
    public void failToRecoverTransactionsAfterCommit(Throwable t, LogEntryCommit commitEntry, LogPosition recoveryToPosition) {
        this.log.warn(String.format("Fail to recover all transactions. Last recoverable transaction id:%d, committed at:%d. Any later transaction after %s are unreadable and will be truncated.", commitEntry.getTxId(), commitEntry.getTimeWritten(), recoveryToPosition), t);
    }

    @Override
    public void failToRecoverTransactionsAfterPosition(Throwable t, LogPosition recoveryFromPosition) {
        this.log.warn(String.format("Fail to recover all transactions. Any later transactions after position %s are unreadable and will be truncated.", recoveryFromPosition), t);
    }

    @Override
    public void startedRotating(long currentVersion) {
    }

    @Override
    public void finishedRotating(long currentVersion) {
    }

    @Override
    public void transactionRecovered(long txId) {
        if (this.firstTransactionRecovered == -1L) {
            this.firstTransactionRecovered = txId;
        }
        this.lastTransactionRecovered = txId;
    }

    @Override
    public void created(File logFile, long logVersion, long lastTransactionId) {
        this.log.info(String.format("Rotated to transaction log [%s] version=%d, last transaction in previous log=%d", logFile, logVersion, lastTransactionId));
    }

    @Override
    public void noCommitsAfterLastCheckPoint(LogPosition logPosition) {
        this.log.info(String.format("No commits found after last check point (which is at %s)", logPosition != null ? logPosition.toString() : "<no log position given>"));
    }

    @Override
    public void commitsAfterLastCheckPoint(LogPosition logPosition, long firstTxIdAfterLastCheckPoint) {
        this.log.info(String.format("Commits found after last check point (which is at %s). First txId after last checkpoint: %d ", logPosition, firstTxIdAfterLastCheckPoint));
    }

    @Override
    public void noCheckPointFound() {
        this.log.info("No check point found in transaction log");
    }
}

