/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class QueryObfuscation {
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("(?:(?i)call)\\s+(?:dbms(?:\\.security)?\\.change(?:User)?Password|dbms\\.security\\.createUser)\\(\\s*(?:\\s*(?:'(?:(?<=\\\\)'|[^'])*'|\"(?:(?<=\\\\)\"|[^\"])*\"|[^,]*)\\s*,)?\\s*('(?:(?<=\\\\)'|[^'])*'|\"(?:(?<=\\\\)\"|[^\"])*\"|\\$\\w*|\\{\\w*})");
    static final TextValue OBFUSCATED = Values.stringValue((String)"******");
    static final String OBFUSCATED_LITERAL = "'******'";

    public static String obfuscateText(String queryText, Set<String> passwordParams) {
        Matcher matcher = PASSWORD_PATTERN.matcher(queryText);
        while (matcher.find()) {
            String password = matcher.group(1).trim();
            if (password.charAt(0) == '$') {
                passwordParams.add(password.substring(1));
                continue;
            }
            if (password.charAt(0) == '{') {
                passwordParams.add(password.substring(1, password.length() - 1));
                continue;
            }
            queryText = queryText.replace(password, OBFUSCATED_LITERAL);
        }
        return queryText;
    }

    public static MapValue obfuscateParams(MapValue queryParameters, Set<String> passwordParams) {
        for (String passwordKey : passwordParams) {
            queryParameters = queryParameters.updatedWith(passwordKey, (AnyValue)OBFUSCATED);
        }
        return queryParameters;
    }
}

