/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a LocalTime instant.")
class LocalTimeFunction
extends TemporalFunction<LocalTimeValue> {
    LocalTimeFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTLocalTime, defaultZone);
    }

    @Override
    protected LocalTimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? LocalTimeValue.now((Clock)clock, defaultZone) : LocalTimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected LocalTimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.parse((TextValue)value);
    }

    @Override
    protected LocalTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected LocalTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected LocalTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }
}

