/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.ExecutingQueryList;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.time.SystemNanoClock;

class KernelTransactionImplementationHandle
implements KernelTransactionHandle {
    private static final String USER_TRANSACTION_NAME_PREFIX = "transaction-";
    private final long txReuseCount;
    private final long lastTransactionIdWhenStarted;
    private final long lastTransactionTimestampWhenStarted;
    private final long startTime;
    private final long startTimeNanos;
    private final long timeoutMillis;
    private final KernelTransactionImplementation tx;
    private final SystemNanoClock clock;
    private final AuthSubject subject;
    private final Optional<Status> terminationReason;
    private final ExecutingQueryList executingQueries;
    private final Map<String, Object> metaData;
    private final long userTransactionId;

    KernelTransactionImplementationHandle(KernelTransactionImplementation tx, SystemNanoClock clock) {
        this.txReuseCount = tx.getReuseCount();
        this.lastTransactionIdWhenStarted = tx.lastTransactionIdWhenStarted();
        this.lastTransactionTimestampWhenStarted = tx.lastTransactionTimestampWhenStarted();
        this.startTime = tx.startTime();
        this.startTimeNanos = tx.startTimeNanos();
        this.timeoutMillis = tx.timeout();
        this.subject = tx.subjectOrAnonymous();
        this.terminationReason = tx.getReasonIfTerminated();
        this.executingQueries = tx.executingQueries();
        this.metaData = tx.getMetaData();
        this.userTransactionId = tx.userTransactionId();
        this.tx = tx;
        this.clock = clock;
    }

    @Override
    public long lastTransactionIdWhenStarted() {
        return this.lastTransactionIdWhenStarted;
    }

    @Override
    public long lastTransactionTimestampWhenStarted() {
        return this.lastTransactionTimestampWhenStarted;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    @Override
    public long timeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public boolean isOpen() {
        return this.tx.isOpen() && this.txReuseCount == (long)this.tx.getReuseCount();
    }

    @Override
    public boolean markForTermination(Status reason) {
        return this.tx.markForTermination(this.txReuseCount, reason);
    }

    @Override
    public AuthSubject subject() {
        return this.subject;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public Optional<Status> terminationReason() {
        return this.terminationReason;
    }

    @Override
    public boolean isUnderlyingTransaction(KernelTransaction tx) {
        return this.tx == tx;
    }

    @Override
    public long getUserTransactionId() {
        return this.userTransactionId;
    }

    @Override
    public String getUserTransactionName() {
        return USER_TRANSACTION_NAME_PREFIX + this.getUserTransactionId();
    }

    @Override
    public Stream<ExecutingQuery> executingQueries() {
        return this.executingQueries.queries();
    }

    @Override
    public Stream<? extends ActiveLock> activeLocks() {
        return this.tx.activeLocks();
    }

    @Override
    public TransactionExecutionStatistic transactionStatistic() {
        if (this.txReuseCount == (long)this.tx.getReuseCount()) {
            return new TransactionExecutionStatistic(this.tx, this.clock, this.startTime);
        }
        return TransactionExecutionStatistic.NOT_AVAILABLE;
    }

    @Override
    public boolean isSchemaTransaction() {
        return this.tx.isSchemaTransaction();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KernelTransactionImplementationHandle that = (KernelTransactionImplementationHandle)o;
        return this.txReuseCount == that.txReuseCount && this.tx.equals(that.tx);
    }

    public int hashCode() {
        return 31 * (int)(this.txReuseCount ^ this.txReuseCount >>> 32) + this.tx.hashCode();
    }

    public String toString() {
        return "KernelTransactionImplementationHandle{txReuseCount=" + this.txReuseCount + ", tx=" + this.tx + "}";
    }
}

