/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IndexSpecifier {
    private static final String GROUP_INDEX_NAME = "INAME";
    private static final String GROUP_QUOTED_INDEX_NAME = "QINAME";
    private static final String GROUP_LABEL = "LABEL";
    private static final String GROUP_QUOTED_LABEL = "QLABEL";
    private static final String GROUP_PROPERTY = "PROPERTY";
    private static final String GROUP_QUOTED_PROPERTY = "QPROPERTY";
    private static final String WHITESPACE = IndexSpecifier.zeroOrMore("\\s");
    private static final String INITIATOR = "\\A" + WHITESPACE;
    private static final String TERMINATOR = WHITESPACE + "\\z";
    private static final String CONTINUE = "\\G" + WHITESPACE;
    private static final String INDEX_NAME = IndexSpecifier.or(IndexSpecifier.identifier("INAME"), IndexSpecifier.quotedIdentifier("QINAME"));
    private static final String LABEL = ":" + WHITESPACE + IndexSpecifier.or(IndexSpecifier.identifier("LABEL"), IndexSpecifier.quotedIdentifier("QLABEL"));
    private static final String INDEX_OR_LABEL = IndexSpecifier.or(INDEX_NAME, LABEL);
    private static final String PROPERTY_CLAUSE_BEGIN = "\\(";
    private static final String PROPERTY;
    private static final String FIRST_PROPERTY;
    private static final String FOLLOWING_PROPERTY;
    private static final String PROPERTY_CLAUSE_END = "\\)";
    private static final Pattern PATTERN_START_INDEX_NAME_OR_LABEL;
    private static final Pattern PATTERN_INDEX_NAME_END;
    private static final Pattern PATTERN_PROPERTY_CLAUSE_BEGIN;
    private static final Pattern PATTERN_FIRST_PROPERTY;
    private static final Pattern PATTERN_FOLLOWING_PROPERTY;
    private static final Pattern PATTERN_PROPERTY_CLAUSE_END;
    private final String specification;
    private final String label;
    private final String[] properties;
    private final String name;

    public static IndexSpecifier byPatternOrName(String specification) {
        return IndexSpecifier.parse(specification, true, true);
    }

    public static IndexSpecifier byPattern(String specification) {
        return IndexSpecifier.parse(specification, false, true);
    }

    public static IndexSpecifier byName(String specification) {
        return IndexSpecifier.parse(specification, true, false);
    }

    private static IndexSpecifier parse(String specification, boolean allowIndexNameSpecs, boolean allowIndexPatternSpecs) {
        Matcher matcher = PATTERN_START_INDEX_NAME_OR_LABEL.matcher(specification);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Cannot parse index specification: '" + specification + "'");
        }
        String indexName = IndexSpecifier.either(matcher.group(GROUP_INDEX_NAME), matcher.group(GROUP_QUOTED_INDEX_NAME));
        if (indexName != null) {
            if (!allowIndexNameSpecs) {
                throw new IllegalArgumentException("Cannot parse index specification: '" + specification + "' - it looks like an index name, which is not allowed.");
            }
            matcher.usePattern(PATTERN_INDEX_NAME_END);
            if (matcher.find()) {
                return new IndexSpecifier(specification, indexName);
            }
            throw new IllegalArgumentException("Invalid characters following index name: '" + specification + "'");
        }
        if (!allowIndexPatternSpecs) {
            throw new IllegalArgumentException("Cannot parse index specification: '" + specification + "' - it looks like an index pattern, but an index name was expected.");
        }
        String label = IndexSpecifier.either(matcher.group(GROUP_LABEL), matcher.group(GROUP_QUOTED_LABEL));
        if (label == null) {
            throw new IllegalArgumentException("Cannot parse index specification: '" + specification + "'");
        }
        matcher.usePattern(PATTERN_PROPERTY_CLAUSE_BEGIN);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Expected to find a property clause following the label: '" + specification + "'");
        }
        matcher.usePattern(PATTERN_FIRST_PROPERTY);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Expected to find a property in the property clause following the label: '" + specification + "'");
        }
        ArrayList<String> properties = new ArrayList<String>();
        do {
            String property;
            if ((property = IndexSpecifier.either(matcher.group(GROUP_PROPERTY), matcher.group(GROUP_QUOTED_PROPERTY))) == null) {
                throw new IllegalArgumentException("Expected to find a property in the property clause following the label: '" + specification + "'");
            }
            properties.add(property);
            if (matcher.pattern() == PATTERN_FOLLOWING_PROPERTY) continue;
            matcher.usePattern(PATTERN_FOLLOWING_PROPERTY);
        } while (matcher.find());
        matcher.usePattern(PATTERN_PROPERTY_CLAUSE_END);
        if (!matcher.find()) {
            throw new IllegalArgumentException("The property clause is not terminated: '" + specification + "'");
        }
        return new IndexSpecifier(specification, label, properties.toArray(new String[0]));
    }

    private static String either(String first, String second) {
        return first != null ? first : second;
    }

    private static String or(String first, String second) {
        return IndexSpecifier.group(IndexSpecifier.group(first) + "|" + IndexSpecifier.group(second));
    }

    private static String identifier(String name) {
        return IndexSpecifier.capture(name, "[A-Za-z0-9_]+");
    }

    private static String quotedIdentifier(String name) {
        return IndexSpecifier.group("`" + IndexSpecifier.capture(name, IndexSpecifier.oneOrMore(IndexSpecifier.group(IndexSpecifier.or("[^`]", "``")))) + "`");
    }

    private static String group(String contents) {
        return "(?:" + contents + ")";
    }

    private static String capture(String name, String contents) {
        return "(?<" + name + ">" + contents + ")";
    }

    private static String zeroOrMore(String terms) {
        return terms + "*";
    }

    private static String oneOrMore(String terms) {
        return terms + "+";
    }

    private IndexSpecifier(String specification, String indexName) {
        this.specification = specification;
        this.label = null;
        this.properties = null;
        this.name = indexName;
    }

    private IndexSpecifier(String specification, String label, String[] properties) {
        this.specification = specification;
        this.label = label;
        this.properties = properties;
        this.name = null;
    }

    public String label() {
        return this.label;
    }

    public String[] properties() {
        return this.properties;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.specification;
    }

    static {
        FIRST_PROPERTY = PROPERTY = IndexSpecifier.or(IndexSpecifier.identifier(GROUP_PROPERTY), IndexSpecifier.quotedIdentifier(GROUP_QUOTED_PROPERTY));
        FOLLOWING_PROPERTY = "," + WHITESPACE + PROPERTY;
        PATTERN_START_INDEX_NAME_OR_LABEL = Pattern.compile(INITIATOR + INDEX_OR_LABEL);
        PATTERN_INDEX_NAME_END = Pattern.compile(CONTINUE + TERMINATOR);
        PATTERN_PROPERTY_CLAUSE_BEGIN = Pattern.compile(CONTINUE + PROPERTY_CLAUSE_BEGIN);
        PATTERN_FIRST_PROPERTY = Pattern.compile(CONTINUE + FIRST_PROPERTY);
        PATTERN_FOLLOWING_PROPERTY = Pattern.compile(CONTINUE + FOLLOWING_PROPERTY);
        PATTERN_PROPERTY_CLAUSE_END = Pattern.compile(CONTINUE + PROPERTY_CLAUSE_END + TERMINATOR);
    }
}

