/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import org.neo4j.internal.diagnostics.DiagnosticsExtractor;
import org.neo4j.internal.diagnostics.DiagnosticsPhase;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.logging.Logger;

enum DataSourceDiagnostics implements DiagnosticsExtractor<NeoStoreDataSource>
{
    TRANSACTION_RANGE("Transaction log:"){

        @Override
        void dump(NeoStoreDataSource source, Logger log) {
            LogFiles logFiles = (LogFiles)source.getDependencyResolver().resolveDependency(LogFiles.class);
            try {
                long logVersion = logFiles.getLowestLogVersion();
                while (logFiles.versionExists(logVersion)) {
                    if (logFiles.hasAnyEntries(logVersion)) {
                        LogHeader header = logFiles.extractHeader(logVersion);
                        long firstTransactionIdInThisLog = header.lastCommittedTxId + 1L;
                        log.log("Oldest transaction " + firstTransactionIdInThisLog + " found in log with version " + logVersion);
                        return;
                    }
                    ++logVersion;
                }
                log.log("No transactions found in any log");
            }
            catch (IOException e) {
                log.log("Error trying to figure out oldest transaction in log");
            }
        }
    };

    private final String message;

    private DataSourceDiagnostics(String message) {
        this.message = message;
    }

    public void dumpDiagnostics(NeoStoreDataSource source, DiagnosticsPhase phase, Logger logger) {
        if (this.applicable(phase)) {
            logger.log(this.message);
            this.dump(source, logger);
        }
    }

    boolean applicable(DiagnosticsPhase phase) {
        return phase.isInitialization() || phase.isExplicitlyRequested();
    }

    abstract void dump(NeoStoreDataSource var1, Logger var2);
}

