/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.io.IOUtils;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class CursorPropertyAccessor
implements NodePropertyAccessor,
AutoCloseable {
    private final NodeCursor nodeCursor;
    private final PropertyCursor propertyCursor;
    private final Read read;

    CursorPropertyAccessor(NodeCursor nodeCursor, PropertyCursor propertyCursor, Read read) {
        this.nodeCursor = nodeCursor;
        this.propertyCursor = propertyCursor;
        this.read = read;
    }

    @Override
    public void close() {
        IOUtils.closeAllSilently((AutoCloseable[])new Cursor[]{this.propertyCursor, this.nodeCursor});
    }

    public Value getNodePropertyValue(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.read.singleNode(nodeId, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        this.nodeCursor.properties(this.propertyCursor);
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKeyId) continue;
            return this.propertyCursor.propertyValue();
        }
        return Values.NO_VALUE;
    }
}

