/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.MarshlandPool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionStateManager;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionImplementationHandle;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.MonotonicCounter;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.time.SystemNanoClock;

public class KernelTransactions
extends LifecycleAdapter
implements Supplier<KernelTransactionsSnapshot> {
    private final StatementLocksFactory statementLocksFactory;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StatementOperationParts statementOperations;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final TransactionCommitProcess transactionCommitProcess;
    private final AuxiliaryTransactionStateManager auxTxStateManager;
    private final TransactionHooks hooks;
    private final TransactionMonitor transactionMonitor;
    private final AvailabilityGuard databaseAvailabilityGuard;
    private final Tracers tracers;
    private final StorageEngine storageEngine;
    private final Procedures procedures;
    private final TransactionIdStore transactionIdStore;
    private final AtomicReference<CpuClock> cpuClockRef;
    private final AtomicReference<HeapAllocation> heapAllocationRef;
    private final AccessCapability accessCapability;
    private final SystemNanoClock clock;
    private final VersionContextSupplier versionContextSupplier;
    private final ReentrantReadWriteLock newTransactionsLock = new ReentrantReadWriteLock();
    private final MonotonicCounter userTransactionIdCounter = MonotonicCounter.newAtomicMonotonicCounter();
    private final AutoIndexing autoIndexing;
    private final ExplicitIndexStore explicitIndexStore;
    private final IndexingService indexingService;
    private final TokenHolders tokenHolders;
    private final String currentDatabaseName;
    private final Dependencies dataSourceDependencies;
    private final Config config;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final SchemaState schemaState;
    private final Set<KernelTransactionImplementation> allTransactions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Factory<KernelTransactionImplementation> factory = new KernelTransactionImplementationFactory(this.allTransactions);
    private final GlobalKernelTransactionPool globalTxPool = new GlobalKernelTransactionPool(this.allTransactions, this.factory);
    private final MarshlandPool<KernelTransactionImplementation> localTxPool = new MarshlandPool((Pool)this.globalTxPool);
    private final ConstraintSemantics constraintSemantics;
    private volatile boolean stopped = true;

    public KernelTransactions(Config config, StatementLocksFactory statementLocksFactory, ConstraintIndexCreator constraintIndexCreator, StatementOperationParts statementOperations, SchemaWriteGuard schemaWriteGuard, TransactionHeaderInformationFactory txHeaderFactory, TransactionCommitProcess transactionCommitProcess, AuxiliaryTransactionStateManager auxTxStateManager, TransactionHooks hooks, TransactionMonitor transactionMonitor, AvailabilityGuard databaseAvailabilityGuard, Tracers tracers, StorageEngine storageEngine, Procedures procedures, TransactionIdStore transactionIdStore, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, AtomicReference<HeapAllocation> heapAllocationRef, AccessCapability accessCapability, AutoIndexing autoIndexing, ExplicitIndexStore explicitIndexStore, VersionContextSupplier versionContextSupplier, CollectionsFactorySupplier collectionsFactorySupplier, ConstraintSemantics constraintSemantics, SchemaState schemaState, IndexingService indexingService, TokenHolders tokenHolders, String currentDatabaseName, Dependencies dataSourceDependencies) {
        this.config = config;
        this.statementLocksFactory = statementLocksFactory;
        this.constraintIndexCreator = constraintIndexCreator;
        this.statementOperations = statementOperations;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionHeaderInformationFactory = txHeaderFactory;
        this.transactionCommitProcess = transactionCommitProcess;
        this.auxTxStateManager = auxTxStateManager;
        this.hooks = hooks;
        this.transactionMonitor = transactionMonitor;
        this.databaseAvailabilityGuard = databaseAvailabilityGuard;
        this.tracers = tracers;
        this.storageEngine = storageEngine;
        this.procedures = procedures;
        this.transactionIdStore = transactionIdStore;
        this.cpuClockRef = cpuClockRef;
        this.heapAllocationRef = heapAllocationRef;
        this.accessCapability = accessCapability;
        this.autoIndexing = autoIndexing;
        this.explicitIndexStore = explicitIndexStore;
        this.indexingService = indexingService;
        this.tokenHolders = tokenHolders;
        this.currentDatabaseName = currentDatabaseName;
        this.dataSourceDependencies = dataSourceDependencies;
        this.versionContextSupplier = versionContextSupplier;
        this.clock = clock;
        this.doBlockNewTransactions();
        this.collectionsFactorySupplier = collectionsFactorySupplier;
        this.constraintSemantics = constraintSemantics;
        this.schemaState = schemaState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelTransaction newInstance(Transaction.Type type, LoginContext loginContext, long timeout) {
        this.assertCurrentThreadIsNotBlockingNewTransactions();
        SecurityContext securityContext = loginContext.authorize(this.tokenHolders.propertyKeyTokens()::getOrCreateId, this.currentDatabaseName);
        while (!this.newTransactionsLock.readLock().tryLock(1L, TimeUnit.SECONDS)) {
            this.assertRunning();
        }
        try {
            this.assertRunning();
            TransactionId lastCommittedTransaction = this.transactionIdStore.getLastCommittedTransaction();
            KernelTransactionImplementation tx = (KernelTransactionImplementation)this.localTxPool.acquire();
            StatementLocks statementLocks = this.statementLocksFactory.newInstance();
            tx.initialize(lastCommittedTransaction.transactionId(), lastCommittedTransaction.commitTimestamp(), statementLocks, type, securityContext, timeout, this.userTransactionIdCounter.incrementAndGet());
            KernelTransactionImplementation kernelTransactionImplementation = tx;
            this.newTransactionsLock.readLock().unlock();
            return kernelTransactionImplementation;
        }
        catch (Throwable throwable) {
            try {
                this.newTransactionsLock.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                throw new TransactionFailureException("Fail to start new transaction.", (Throwable)ie);
            }
        }
    }

    public Set<KernelTransactionHandle> activeTransactions() {
        return this.allTransactions.stream().map(this::createHandle).filter(KernelTransactionHandle::isOpen).collect(Collectors.toSet());
    }

    public void disposeAll() {
        this.terminateTransactions();
        this.localTxPool.close();
        this.globalTxPool.close();
    }

    public void terminateTransactions() {
        this.markAllTransactionsAsTerminated();
    }

    private void markAllTransactionsAsTerminated() {
        this.allTransactions.forEach(tx -> tx.markForTermination((Status)Status.General.DatabaseUnavailable));
    }

    public boolean haveClosingTransaction() {
        return this.allTransactions.stream().anyMatch(KernelTransactionImplementation::isClosing);
    }

    public void start() {
        this.stopped = false;
        this.unblockNewTransactions();
    }

    public void stop() {
        this.blockNewTransactions();
        this.stopped = true;
    }

    public void shutdown() {
        this.disposeAll();
    }

    @Override
    public KernelTransactionsSnapshot get() {
        return new KernelTransactionsSnapshot(this.activeTransactions(), this.clock.millis());
    }

    public void blockNewTransactions() {
        this.doBlockNewTransactions();
    }

    private void doBlockNewTransactions() {
        this.newTransactionsLock.writeLock().lock();
    }

    public void unblockNewTransactions() {
        if (!this.newTransactionsLock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("This thread did not block transactions previously");
        }
        this.newTransactionsLock.writeLock().unlock();
    }

    KernelTransactionHandle createHandle(KernelTransactionImplementation tx) {
        return new KernelTransactionImplementationHandle(tx, this.clock);
    }

    private void assertRunning() {
        if (this.databaseAvailabilityGuard.isShutdown()) {
            throw new DatabaseShutdownException();
        }
        if (this.stopped) {
            throw new IllegalStateException("Can't start new transaction with stopped " + this.getClass());
        }
    }

    private void assertCurrentThreadIsNotBlockingNewTransactions() {
        if (this.newTransactionsLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("Thread that is blocking new transactions from starting can't start new transaction");
        }
    }

    private static class GlobalKernelTransactionPool
    extends LinkedQueuePool<KernelTransactionImplementation> {
        private final Set<KernelTransactionImplementation> transactions;

        GlobalKernelTransactionPool(Set<KernelTransactionImplementation> transactions, Factory<KernelTransactionImplementation> factory) {
            super(8, factory);
            this.transactions = transactions;
        }

        protected void dispose(KernelTransactionImplementation tx) {
            this.transactions.remove(tx);
            tx.dispose();
            super.dispose((Object)tx);
        }
    }

    private class KernelTransactionImplementationFactory
    implements Factory<KernelTransactionImplementation> {
        private final Set<KernelTransactionImplementation> transactions;

        KernelTransactionImplementationFactory(Set<KernelTransactionImplementation> transactions) {
            this.transactions = transactions;
        }

        public KernelTransactionImplementation newInstance() {
            KernelTransactionImplementation tx = new KernelTransactionImplementation(KernelTransactions.this.config, KernelTransactions.this.statementOperations, KernelTransactions.this.schemaWriteGuard, KernelTransactions.this.hooks, KernelTransactions.this.constraintIndexCreator, KernelTransactions.this.procedures, KernelTransactions.this.transactionHeaderInformationFactory, KernelTransactions.this.transactionCommitProcess, KernelTransactions.this.transactionMonitor, KernelTransactions.this.auxTxStateManager, (Pool<KernelTransactionImplementation>)KernelTransactions.this.localTxPool, KernelTransactions.this.clock, KernelTransactions.this.cpuClockRef, KernelTransactions.this.heapAllocationRef, ((KernelTransactions)KernelTransactions.this).tracers.transactionTracer, ((KernelTransactions)KernelTransactions.this).tracers.lockTracer, ((KernelTransactions)KernelTransactions.this).tracers.pageCursorTracerSupplier, KernelTransactions.this.storageEngine, KernelTransactions.this.accessCapability, KernelTransactions.this.autoIndexing, KernelTransactions.this.explicitIndexStore, KernelTransactions.this.versionContextSupplier, KernelTransactions.this.collectionsFactorySupplier, KernelTransactions.this.constraintSemantics, KernelTransactions.this.schemaState, KernelTransactions.this.indexingService, KernelTransactions.this.tokenHolders, KernelTransactions.this.dataSourceDependencies);
            this.transactions.add(tx);
            return tx;
        }
    }
}

