/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.util.collection.AbstractLinearProbeLongHashSet;
import org.neo4j.kernel.impl.util.collection.Memory;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

class MutableLinearProbeLongHashSet
extends AbstractLinearProbeLongHashSet
implements MutableLongSet,
Resource {
    static final int DEFAULT_CAPACITY = 32;
    static final int REMOVALS_RATIO = 4;
    private static final double LOAD_FACTOR = 0.75;
    private final MemoryAllocator allocator;
    private final MutableMultimap<Memory, FrozenCopy> frozenCopies;
    private int resizeOccupancyThreshold;
    private int resizeRemovalsThreshold;
    private int removals;
    private boolean frozen;

    MutableLinearProbeLongHashSet(MemoryAllocator allocator) {
        this.frozenCopies = Multimaps.mutable.list.empty();
        this.allocator = Objects.requireNonNull(allocator);
        this.allocateMemory(32);
    }

    public boolean add(long element) {
        ++this.modCount;
        if (element == 0L) {
            boolean hadZero = this.hasZero;
            this.hasZero = true;
            return hadZero != this.hasZero;
        }
        if (element == 1L) {
            boolean hadOne = this.hasOne;
            this.hasOne = true;
            return hadOne != this.hasOne;
        }
        return this.addToMemory(element);
    }

    public boolean addAll(long ... elements) {
        ++this.modCount;
        int prevSize = this.size();
        for (long element : elements) {
            this.add(element);
        }
        return prevSize != this.size();
    }

    public boolean addAll(LongIterable elements) {
        ++this.modCount;
        int prevSize = this.size();
        elements.forEach(this::add);
        return prevSize != this.size();
    }

    public boolean remove(long element) {
        ++this.modCount;
        if (element == 0L) {
            boolean hadZero = this.hasZero;
            this.hasZero = false;
            return hadZero != this.hasZero;
        }
        if (element == 1L) {
            boolean hadOne = this.hasOne;
            this.hasOne = false;
            return hadOne != this.hasOne;
        }
        return this.removeFromMemory(element);
    }

    public boolean removeAll(LongIterable elements) {
        ++this.modCount;
        int prevSize = this.size();
        elements.forEach(this::remove);
        return prevSize != this.size();
    }

    public boolean removeAll(long ... elements) {
        ++this.modCount;
        int prevSize = this.size();
        for (long element : elements) {
            this.remove(element);
        }
        return prevSize != this.size();
    }

    public boolean retainAll(LongIterable elements) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(long ... source) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        ++this.modCount;
        this.copyIfFrozen();
        this.memory.clear();
        this.hasZero = false;
        this.hasOne = false;
        this.elementsInMemory = 0;
        this.removals = 0;
    }

    public MutableLongIterator longIterator() {
        return new AbstractLinearProbeLongHashSet.FailFastIterator(this);
    }

    public void close() {
        ++this.modCount;
        if (this.memory != null) {
            this.frozenCopies.forEachKeyMultiValues((Procedure2 & Serializable)(mem, copies) -> {
                mem.free();
                copies.forEach(FrozenCopy::invalidate);
            });
            if (!this.frozenCopies.containsKey((Object)this.memory)) {
                this.memory.free();
            }
            this.memory = null;
            this.frozenCopies.clear();
        }
    }

    public MutableLongSet tap(LongProcedure procedure) {
        this.each(procedure);
        return this;
    }

    public MutableLongSet with(long element) {
        this.add(element);
        return this;
    }

    public MutableLongSet without(long element) {
        this.remove(element);
        return this;
    }

    public MutableLongSet withAll(LongIterable elements) {
        this.addAll(elements);
        return this;
    }

    public MutableLongSet withoutAll(LongIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public MutableLongSet asUnmodifiable() {
        return new UnmodifiableLongSet((MutableLongSet)this);
    }

    public MutableLongSet asSynchronized() {
        return new SynchronizedLongSet((MutableLongSet)this);
    }

    public LongSet freeze() {
        this.frozen = true;
        FrozenCopy frozen = new FrozenCopy();
        this.frozenCopies.put((Object)this.memory, (Object)frozen);
        return frozen;
    }

    public ImmutableLongSet toImmutable() {
        throw new UnsupportedOperationException();
    }

    private boolean removeFromMemory(long element) {
        int idx = this.indexOf(element);
        long valueAtIdx = this.memory.readLong((long)idx * 8L);
        if (valueAtIdx != element) {
            return false;
        }
        this.copyIfFrozen();
        this.memory.writeLong((long)idx * 8L, 1L);
        --this.elementsInMemory;
        ++this.removals;
        if (this.removals >= this.resizeRemovalsThreshold) {
            this.rehashWithoutGrow();
        }
        return true;
    }

    private boolean addToMemory(long element) {
        int idx = this.indexOf(element);
        long valueAtIdx = this.valueAt(idx);
        if (valueAtIdx == element) {
            return false;
        }
        if (valueAtIdx == 1L) {
            --this.removals;
        }
        this.copyIfFrozen();
        this.memory.writeLong((long)idx * 8L, element);
        ++this.elementsInMemory;
        if (this.elementsInMemory >= this.resizeOccupancyThreshold) {
            this.growAndRehash();
        }
        return true;
    }

    @VisibleForTesting
    void growAndRehash() {
        int newCapacity = this.capacity * 2;
        if (newCapacity < this.capacity) {
            throw new RuntimeException("LongSet reached capacity limit");
        }
        this.rehash(newCapacity);
    }

    @VisibleForTesting
    void rehashWithoutGrow() {
        this.rehash(this.capacity);
    }

    private void allocateMemory(int newCapacity) {
        Preconditions.checkArgument((newCapacity > 1 && Integer.bitCount(newCapacity) == 1 ? 1 : 0) != 0, (String)"Capacity must be power of 2", (Object[])new Object[0]);
        this.capacity = newCapacity;
        this.resizeOccupancyThreshold = (int)((double)newCapacity * 0.75);
        this.resizeRemovalsThreshold = newCapacity / 4;
        this.memory = this.allocator.allocate((long)newCapacity * 8L, true);
    }

    private void rehash(int newCapacity) {
        int prevCapacity = this.capacity;
        Memory prevMemory = this.memory;
        this.elementsInMemory = 0;
        this.removals = 0;
        this.allocateMemory(newCapacity);
        for (int i = 0; i < prevCapacity; ++i) {
            long value = prevMemory.readLong((long)i * 8L);
            if (!MutableLinearProbeLongHashSet.isRealValue(value)) continue;
            this.add(value);
        }
        prevMemory.free();
    }

    private void copyIfFrozen() {
        if (this.frozen) {
            this.frozen = false;
            this.memory = this.memory.copy();
        }
    }

    class FrozenCopy
    extends AbstractLinearProbeLongHashSet {
        FrozenCopy() {
            super(MutableLinearProbeLongHashSet.this);
        }

        public LongSet freeze() {
            return this;
        }

        public ImmutableLongSet toImmutable() {
            throw new UnsupportedOperationException();
        }

        void invalidate() {
            ++this.modCount;
        }
    }
}

