/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialLayout
extends IndexLayout<SpatialIndexKey, NativeIndexValue> {
    private SpaceFillingCurve curve;
    CoordinateReferenceSystem crs;

    SpatialLayout(CoordinateReferenceSystem crs, SpaceFillingCurve curve) {
        super("UPI", 0, 1);
        this.crs = crs;
        this.curve = curve;
    }

    SpaceFillingCurve getSpaceFillingCurve() {
        return this.curve;
    }

    public SpatialIndexKey newKey() {
        return new SpatialIndexKey(this.crs, this.curve);
    }

    public SpatialIndexKey copyKey(SpatialIndexKey key, SpatialIndexKey into) {
        into.rawValueBits = key.rawValueBits;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        into.crs = key.crs;
        into.curve = key.curve;
        return into;
    }

    public int keySize(SpatialIndexKey key) {
        return 16;
    }

    public void writeKey(PageCursor cursor, SpatialIndexKey key) {
        cursor.putLong(key.rawValueBits);
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, SpatialIndexKey into, int keySize) {
        into.rawValueBits = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }
}

