/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedPopulatingIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.PopulatingIndexProxy;
import org.neo4j.kernel.impl.api.index.RecoveringIndexProxy;
import org.neo4j.kernel.impl.api.index.TentativeConstraintIndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

class IndexProxyCreator {
    private final IndexSamplingConfig samplingConfig;
    private final IndexStoreView storeView;
    private final IndexProviderMap providerMap;
    private final TokenNameLookup tokenNameLookup;
    private final LogProvider logProvider;

    IndexProxyCreator(IndexSamplingConfig samplingConfig, IndexStoreView storeView, IndexProviderMap providerMap, TokenNameLookup tokenNameLookup, LogProvider logProvider) {
        this.samplingConfig = samplingConfig;
        this.storeView = storeView;
        this.providerMap = providerMap;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
    }

    IndexProxy createPopulatingIndexProxy(StoreIndexDescriptor descriptor, boolean flipToTentative, IndexingService.Monitor monitor, IndexPopulationJob populationJob) {
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        String indexUserDescription = this.indexUserDescription(descriptor);
        IndexPopulator populator = this.populatorFromProvider(descriptor, this.samplingConfig, populationJob.bufferFactory());
        CapableIndexDescriptor capableIndexDescriptor = this.providerMap.withCapabilities(descriptor);
        FailedPopulatingIndexProxyFactory failureDelegateFactory = new FailedPopulatingIndexProxyFactory(capableIndexDescriptor, populator, indexUserDescription, new IndexCountsRemover(this.storeView, descriptor.getId()), this.logProvider);
        MultipleIndexPopulator.IndexPopulation indexPopulation = populationJob.addPopulator(populator, capableIndexDescriptor, indexUserDescription, flipper, failureDelegateFactory);
        PopulatingIndexProxy populatingIndex = new PopulatingIndexProxy(capableIndexDescriptor, populationJob, indexPopulation);
        flipper.flipTo(populatingIndex);
        flipper.setFlipTarget(() -> {
            monitor.populationCompleteOn(descriptor);
            IndexAccessor accessor = this.onlineAccessorFromProvider(descriptor, this.samplingConfig);
            OnlineIndexProxy onlineProxy = new OnlineIndexProxy(capableIndexDescriptor, accessor, this.storeView, true);
            if (flipToTentative) {
                return new TentativeConstraintIndexProxy(flipper, onlineProxy);
            }
            return onlineProxy;
        });
        return new ContractCheckingIndexProxy(flipper);
    }

    IndexProxy createRecoveringIndexProxy(StoreIndexDescriptor descriptor) {
        CapableIndexDescriptor capableIndexDescriptor = this.providerMap.withCapabilities(descriptor);
        RecoveringIndexProxy proxy = new RecoveringIndexProxy(capableIndexDescriptor);
        return new ContractCheckingIndexProxy(proxy);
    }

    IndexProxy createOnlineIndexProxy(StoreIndexDescriptor descriptor) {
        try {
            IndexAccessor onlineAccessor = this.onlineAccessorFromProvider(descriptor, this.samplingConfig);
            CapableIndexDescriptor capableIndexDescriptor = this.providerMap.withCapabilities(descriptor);
            IndexProxy proxy = new OnlineIndexProxy(capableIndexDescriptor, onlineAccessor, this.storeView, false);
            proxy = new ContractCheckingIndexProxy(proxy);
            return proxy;
        }
        catch (IOException e) {
            this.logProvider.getLog(this.getClass()).error("Failed to open index: " + descriptor.getId() + " (" + descriptor.userDescription(this.tokenNameLookup) + "), requesting re-population.", (Throwable)e);
            return this.createRecoveringIndexProxy(descriptor);
        }
    }

    IndexProxy createFailedIndexProxy(StoreIndexDescriptor descriptor, IndexPopulationFailure populationFailure) {
        IndexPopulator indexPopulator = this.populatorFromProvider(descriptor, this.samplingConfig, ByteBufferFactory.heapBufferFactory(1024));
        CapableIndexDescriptor capableIndexDescriptor = this.providerMap.withCapabilities(descriptor);
        String indexUserDescription = this.indexUserDescription(descriptor);
        IndexProxy proxy = new FailedIndexProxy(capableIndexDescriptor, indexUserDescription, indexPopulator, populationFailure, new IndexCountsRemover(this.storeView, descriptor.getId()), this.logProvider);
        proxy = new ContractCheckingIndexProxy(proxy);
        return proxy;
    }

    private String indexUserDescription(StoreIndexDescriptor descriptor) {
        return String.format("%s [provider: %s]", descriptor.schema().userDescription(this.tokenNameLookup), descriptor.providerDescriptor().toString());
    }

    private IndexPopulator populatorFromProvider(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory) {
        IndexProvider indexProvider = this.providerMap.lookup(descriptor.providerDescriptor());
        return indexProvider.getPopulator(descriptor, samplingConfig, bufferFactory);
    }

    private IndexAccessor onlineAccessorFromProvider(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        IndexProvider indexProvider = this.providerMap.lookup(descriptor.providerDescriptor());
        return indexProvider.getOnlineAccessor(descriptor, samplingConfig);
    }
}

