/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.builtinprocs.ConfigResult;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BuiltInDbmsProcedures {
    @Context
    public Log log;
    @Context
    public GraphDatabaseAPI graph;
    @Context
    public SecurityContext securityContext;

    @Admin
    @Description(value="List the currently active config of Neo4j.")
    @Procedure(name="dbms.listConfig", mode=Mode.DBMS)
    public Stream<ConfigResult> listConfig(@Name(value="searchString", defaultValue="") String searchString) {
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        String lowerCasedSearchString = searchString.toLowerCase();
        return config.getConfigValues().values().stream().filter(c -> !c.internal()).filter(c -> c.name().toLowerCase().contains(lowerCasedSearchString)).map(ConfigResult::new).sorted(Comparator.comparing(c -> c.name));
    }

    @Internal
    @Description(value="Return config settings interesting to clients (e.g. Neo4j Browser)")
    @Procedure(name="dbms.clientConfig", mode=Mode.DBMS)
    public Stream<ConfigResult> listClientConfig() {
        Set browserSettings = Stream.of("browser.allow_outgoing_connections", "browser.credential_timeout", "browser.retain_connection_credentials", "dbms.security.auth_enabled", "browser.remote_content_hostname_whitelist", "browser.post_connect_cmd").collect(Collectors.toCollection(HashSet::new));
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        return config.getConfigValues().values().stream().filter(c -> browserSettings.contains(c.name().toLowerCase())).map(ConfigResult::new).sorted(Comparator.comparing(c -> c.name));
    }

    @Description(value="List all procedures in the DBMS.")
    @Procedure(name="dbms.procedures", mode=Mode.DBMS)
    public Stream<ProcedureResult> listProcedures() {
        this.securityContext.assertCredentialsNotExpired();
        return ((Procedures)((Object)this.graph.getDependencyResolver().resolveDependency(Procedures.class))).getAllProcedures().stream().filter(proc -> !proc.internal()).sorted(Comparator.comparing(a -> a.name().toString())).map(x$0 -> new ProcedureResult((ProcedureSignature)x$0));
    }

    @Description(value="List all user functions in the DBMS.")
    @Procedure(name="dbms.functions", mode=Mode.DBMS)
    public Stream<FunctionResult> listFunctions() {
        this.securityContext.assertCredentialsNotExpired();
        return ((Procedures)((Object)this.graph.getDependencyResolver().resolveDependency(Procedures.class))).getAllFunctions().stream().sorted(Comparator.comparing(a -> a.name().toString())).map(x$0 -> new FunctionResult((UserFunctionSignature)x$0));
    }

    @Admin
    @Description(value="Clears all query caches.")
    @Procedure(name="dbms.clearQueryCaches", mode=Mode.DBMS)
    public Stream<StringResult> clearAllQueryCaches() {
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)this.graph.getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        long numberOfClearedQueries = queryExecutionEngine.clearQueryCaches() - 1L;
        String result = numberOfClearedQueries == 0L ? "Query cache already empty." : "Query caches successfully cleared of " + numberOfClearedQueries + " queries.";
        this.log.info("Called dbms.clearQueryCaches(): " + result);
        return Stream.of(new StringResult(result));
    }

    public static class StringResult {
        public final String value;

        StringResult(String value) {
            this.value = value;
        }
    }

    public static class ProcedureResult {
        public final String name;
        public final String signature;
        public final String description;
        public final String mode;

        private ProcedureResult(ProcedureSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
            this.mode = signature.mode().toString();
        }
    }

    public static class FunctionResult {
        public final String name;
        public final String signature;
        public final String description;

        private FunctionResult(UserFunctionSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
        }
    }
}

