/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class BridgingCacheAccess
implements CacheAccessBackDoor {
    private final SchemaCache schemaCache;
    private final SchemaState schemaState;
    private final TokenHolders tokenHolders;

    public BridgingCacheAccess(SchemaCache schemaCache, SchemaState schemaState, TokenHolders tokenHolders) {
        this.schemaCache = schemaCache;
        this.schemaState = schemaState;
        this.tokenHolders = tokenHolders;
    }

    @Override
    public void addSchemaRule(SchemaRule rule) {
        this.schemaCache.addSchemaRule(rule);
    }

    @Override
    public void removeSchemaRuleFromCache(long id) {
        this.schemaCache.removeSchemaRule(id);
        this.schemaState.clear();
    }

    @Override
    public void addRelationshipTypeToken(NamedToken type) {
        this.tokenHolders.relationshipTypeTokens().addToken(type);
    }

    @Override
    public void addLabelToken(NamedToken label) {
        this.tokenHolders.labelTokens().addToken(label);
    }

    @Override
    public void addPropertyKeyToken(NamedToken propertyKey) {
        this.tokenHolders.propertyKeyTokens().addToken(propertyKey);
    }
}

