/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.Closeable;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.SwallowingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;

public interface IndexAccessor
extends Closeable {
    public static final IndexAccessor EMPTY = new Adapter();

    public void drop();

    public IndexUpdater newUpdater(IndexUpdateMode var1);

    public void force(IOLimiter var1);

    public void refresh();

    @Override
    public void close();

    public IndexReader newReader();

    public BoundedIterable<Long> newAllEntriesReader();

    public ResourceIterator<File> snapshotFiles();

    public void verifyDeferredConstraints(NodePropertyAccessor var1) throws IndexEntryConflictException;

    public boolean isDirty();

    default public void validateBeforeCommit(Value[] tuple) {
    }

    public static class Delegator
    implements IndexAccessor {
        private final IndexAccessor delegate;

        public Delegator(IndexAccessor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void drop() {
            this.delegate.drop();
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return this.delegate.newUpdater(mode);
        }

        @Override
        public void force(IOLimiter ioLimiter) {
            this.delegate.force(ioLimiter);
        }

        @Override
        public void refresh() {
            this.delegate.refresh();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public IndexReader newReader() {
            return this.delegate.newReader();
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader() {
            return this.delegate.newAllEntriesReader();
        }

        @Override
        public ResourceIterator<File> snapshotFiles() {
            return this.delegate.snapshotFiles();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
            this.delegate.verifyDeferredConstraints(nodePropertyAccessor);
        }

        @Override
        public boolean isDirty() {
            return this.delegate.isDirty();
        }

        @Override
        public void validateBeforeCommit(Value[] tuple) {
            this.delegate.validateBeforeCommit(tuple);
        }
    }

    public static class Adapter
    implements IndexAccessor {
        @Override
        public void drop() {
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void force(IOLimiter ioLimiter) {
        }

        @Override
        public void refresh() {
        }

        @Override
        public void close() {
        }

        @Override
        public IndexReader newReader() {
            return IndexReader.EMPTY;
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader() {
            return new BoundedIterable<Long>(){

                @Override
                public long maxCount() {
                    return 0L;
                }

                @Override
                public void close() {
                }

                @Override
                public Iterator<Long> iterator() {
                    return Collections.emptyIterator();
                }
            };
        }

        @Override
        public ResourceIterator<File> snapshotFiles() {
            return Iterators.emptyResourceIterator();
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
        }

        @Override
        public boolean isDirty() {
            return false;
        }
    }
}

