/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.LongFunction;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.BatchingIdGetter;
import org.neo4j.unsafe.impl.batchimport.DataImporter;
import org.neo4j.unsafe.impl.batchimport.DataStatistics;
import org.neo4j.unsafe.impl.batchimport.EntityImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.MissingRelationshipDataException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.PrepareIdSequence;

public class RelationshipImporter
extends EntityImporter {
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeTokenRepository;
    private final IdMapper idMapper;
    private final RelationshipStore relationshipStore;
    private final RelationshipRecord relationshipRecord;
    private final BatchingIdGetter relationshipIds;
    private final DataStatistics.Client typeCounts;
    private final Collector badCollector;
    private final boolean validateRelationshipData;
    private final boolean doubleRecordUnits;
    private final LongFunction<IdSequence> prepareIdSequence;
    private long relationshipCount;
    private Object startId;
    private Group startIdGroup;
    private Object endId;
    private Group endIdGroup;
    private String type;

    protected RelationshipImporter(BatchingNeoStores stores, IdMapper idMapper, DataStatistics typeDistribution, DataImporter.Monitor monitor, Collector badCollector, boolean validateRelationshipData, boolean doubleRecordUnits) {
        super(stores, monitor);
        this.doubleRecordUnits = doubleRecordUnits;
        this.relationshipTypeTokenRepository = stores.getRelationshipTypeRepository();
        this.idMapper = idMapper;
        this.badCollector = badCollector;
        this.validateRelationshipData = validateRelationshipData;
        this.relationshipStore = stores.getRelationshipStore();
        this.relationshipRecord = (RelationshipRecord)this.relationshipStore.newRecord();
        this.relationshipIds = new BatchingIdGetter(this.relationshipStore);
        this.typeCounts = typeDistribution.newClient();
        this.prepareIdSequence = (LongFunction)PrepareIdSequence.of(doubleRecordUnits).apply(stores.getRelationshipStore());
        this.relationshipRecord.setInUse(true);
    }

    @Override
    protected PrimitiveRecord primitiveRecord() {
        return this.relationshipRecord;
    }

    @Override
    public boolean startId(long id) {
        this.relationshipRecord.setFirstNode(id);
        return true;
    }

    @Override
    public boolean startId(Object id, Group group) {
        this.startId = id;
        this.startIdGroup = group;
        long nodeId = this.nodeId(id, group);
        this.relationshipRecord.setFirstNode(nodeId);
        return true;
    }

    @Override
    public boolean endId(long id) {
        this.relationshipRecord.setSecondNode(id);
        return true;
    }

    @Override
    public boolean endId(Object id, Group group) {
        this.endId = id;
        this.endIdGroup = group;
        long nodeId = this.nodeId(id, group);
        this.relationshipRecord.setSecondNode(nodeId);
        return true;
    }

    private long nodeId(Object id, Group group) {
        long nodeId = this.idMapper.get(id, group);
        if (nodeId == -1L) {
            this.relationshipRecord.setInUse(false);
            return -1L;
        }
        return nodeId;
    }

    @Override
    public boolean type(int typeId) {
        this.relationshipRecord.setType(typeId);
        return true;
    }

    @Override
    public boolean type(String type) {
        this.type = type;
        int typeId = this.relationshipTypeTokenRepository.getOrCreateId(type);
        return this.type(typeId);
    }

    @Override
    public void endOfEntity() {
        if (this.relationshipRecord.inUse() && this.relationshipRecord.getFirstNode() != -1L && this.relationshipRecord.getSecondNode() != -1L && this.relationshipRecord.getType() != -1) {
            this.relationshipRecord.setId(this.relationshipIds.next());
            if (this.doubleRecordUnits) {
                this.relationshipIds.next();
            }
            this.relationshipRecord.setNextProp(this.createAndWritePropertyChain());
            this.relationshipRecord.setFirstInFirstChain(false);
            this.relationshipRecord.setFirstInSecondChain(false);
            this.relationshipRecord.setFirstPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
            this.relationshipRecord.setSecondPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
            this.relationshipStore.prepareForCommit(this.relationshipRecord, this.prepareIdSequence.apply(this.relationshipRecord.getId()));
            this.relationshipStore.updateRecord(this.relationshipRecord);
            ++this.relationshipCount;
            this.typeCounts.increment(this.relationshipRecord.getType());
        } else {
            if (this.validateRelationshipData) {
                this.validateNode(this.startId, Type.START_ID);
                this.validateNode(this.endId, Type.END_ID);
                if (this.relationshipRecord.getType() == -1) {
                    throw new MissingRelationshipDataException(Type.TYPE, this.relationshipDataString() + " is missing " + (Object)((Object)Type.TYPE) + " field");
                }
            }
            this.badCollector.collectBadRelationship(this.startId, this.group(this.startIdGroup).name(), this.type, this.endId, this.group(this.endIdGroup).name(), this.relationshipRecord.getFirstNode() == -1L ? this.startId : this.endId);
            this.entityPropertyCount = 0;
        }
        this.relationshipRecord.clear();
        this.relationshipRecord.setInUse(true);
        this.startId = null;
        this.startIdGroup = null;
        this.endId = null;
        this.endIdGroup = null;
        this.type = null;
        super.endOfEntity();
    }

    private Group group(Group group) {
        return group != null ? group : Group.GLOBAL;
    }

    private void validateNode(Object id, Type fieldType) {
        if (id == null) {
            throw new MissingRelationshipDataException(fieldType, this.relationshipDataString() + " is missing " + (Object)((Object)fieldType) + " field");
        }
    }

    private String relationshipDataString() {
        return String.format("start:%s (%s) type:%s end:%s (%s)", this.startId, this.group(this.startIdGroup).name(), this.type, this.endId, this.group(this.endIdGroup).name());
    }

    @Override
    public void close() {
        super.close();
        this.typeCounts.close();
        this.monitor.relationshipsImported(this.relationshipCount);
    }
}

