/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.util.NodeProxyWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipProxyWrappingValue;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class ValueUtils {
    private ValueUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static AnyValue of(Object object) {
        Value value = Values.unsafeOf((Object)object, (boolean)true);
        if (value != null) {
            return value;
        }
        if (object instanceof Entity) {
            if (object instanceof Node) {
                return ValueUtils.fromNodeProxy((Node)object);
            }
            if (object instanceof Relationship) {
                return ValueUtils.fromRelationshipProxy((Relationship)object);
            }
            throw new IllegalArgumentException("Unknown entity + " + object.getClass().getName());
        }
        if (object instanceof Iterable) {
            if (object instanceof Path) {
                return ValueUtils.fromPath((Path)object);
            }
            if (object instanceof List) {
                return ValueUtils.asListValue((List)object);
            }
            return ValueUtils.asListValue((Iterable)object);
        }
        if (object instanceof Map) {
            return ValueUtils.asMapValue((Map)object);
        }
        if (object instanceof Iterator) {
            ArrayList objects = new ArrayList();
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                objects.add(iterator.next());
            }
            return ValueUtils.asListValue(objects);
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            AnyValue[] anyValues = new AnyValue[array.length];
            for (int i = 0; i < array.length; ++i) {
                anyValues[i] = ValueUtils.of(array[i]);
            }
            return VirtualValues.list((AnyValue[])anyValues);
        }
        if (object instanceof Stream) {
            return ValueUtils.asListValue(((Stream)object).collect(Collectors.toList()));
        }
        if (object instanceof Geometry) {
            return ValueUtils.asGeometryValue((Geometry)object);
        }
        if (object instanceof VirtualNodeValue || object instanceof VirtualRelationshipValue) {
            return (AnyValue)object;
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to AnyValue", object.getClass().getName()));
    }

    public static PointValue asPointValue(Point point) {
        return ValueUtils.toPoint((Geometry)point);
    }

    public static PointValue asGeometryValue(Geometry geometry) {
        if (!geometry.getGeometryType().equals("Point")) {
            throw new IllegalArgumentException("Cannot handle geometry type: " + geometry.getCRS().getType());
        }
        return ValueUtils.toPoint(geometry);
    }

    private static PointValue toPoint(Geometry geometry) {
        List coordinate = ((Coordinate)geometry.getCoordinates().get(0)).getCoordinate();
        double[] primitiveCoordinate = new double[coordinate.size()];
        for (int i = 0; i < coordinate.size(); ++i) {
            primitiveCoordinate[i] = (Double)coordinate.get(i);
        }
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.get((CRS)geometry.getCRS()), (double[])primitiveCoordinate);
    }

    public static ListValue asListValue(List<?> collection) {
        ArrayList<AnyValue> values = new ArrayList<AnyValue>(collection.size());
        for (Object o : collection) {
            values.add(ValueUtils.of(o));
        }
        return VirtualValues.fromList(values);
    }

    public static ListValue asListValue(Iterable<?> collection) {
        ArrayList<AnyValue> values = new ArrayList<AnyValue>();
        for (Object o : collection) {
            values.add(ValueUtils.of(o));
        }
        return VirtualValues.fromList(values);
    }

    public static AnyValue asNodeOrEdgeValue(PropertyContainer container) {
        if (container instanceof Node) {
            return ValueUtils.fromNodeProxy((Node)container);
        }
        if (container instanceof Relationship) {
            return ValueUtils.fromRelationshipProxy((Relationship)container);
        }
        throw new IllegalArgumentException("Cannot produce a node or edge from " + container.getClass().getName());
    }

    public static ListValue asListOfEdges(Iterable<Relationship> rels) {
        return VirtualValues.list((AnyValue[])((AnyValue[])StreamSupport.stream(rels.spliterator(), false).map(ValueUtils::fromRelationshipProxy).toArray(RelationshipValue[]::new)));
    }

    public static ListValue asListOfEdges(Relationship[] rels) {
        RelationshipValue[] relValues = new RelationshipValue[rels.length];
        for (int i = 0; i < relValues.length; ++i) {
            relValues[i] = ValueUtils.fromRelationshipProxy(rels[i]);
        }
        return VirtualValues.list((AnyValue[])relValues);
    }

    public static MapValue asMapValue(Map<String, Object> map) {
        MapValueBuilder builder = new MapValueBuilder(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            builder.add(entry.getKey(), ValueUtils.of(entry.getValue()));
        }
        return builder.build();
    }

    public static MapValue asParameterMapValue(Map<String, Object> map) {
        MapValueBuilder builder = new MapValueBuilder(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                builder.add(entry.getKey(), ValueUtils.of(entry.getValue()));
            }
            catch (IllegalArgumentException e) {
                builder.add(entry.getKey(), (AnyValue)VirtualValues.error((Exception)e));
            }
        }
        return builder.build();
    }

    public static NodeValue fromNodeProxy(Node node) {
        return new NodeProxyWrappingNodeValue(node);
    }

    public static RelationshipValue fromRelationshipProxy(Relationship relationship) {
        return new RelationshipProxyWrappingValue(relationship);
    }

    public static PathValue fromPath(Path path) {
        return new PathWrappingPathValue(path);
    }

    public static Value asValue(Object value) {
        if (value instanceof Value) {
            return (Value)value;
        }
        return Values.of((Object)value);
    }

    public static AnyValue asAnyValue(Object value) {
        if (value instanceof AnyValue) {
            return (AnyValue)value;
        }
        return ValueUtils.of(value);
    }

    public static NodeValue asNodeValue(Object object) {
        if (object instanceof NodeValue) {
            return (NodeValue)object;
        }
        if (object instanceof Node) {
            return ValueUtils.fromNodeProxy((Node)object);
        }
        throw new IllegalArgumentException("Cannot produce a node from " + object.getClass().getName());
    }

    public static RelationshipValue asRelationshipValue(Object object) {
        if (object instanceof RelationshipValue) {
            return (RelationshipValue)object;
        }
        if (object instanceof Relationship) {
            return ValueUtils.fromRelationshipProxy((Relationship)object);
        }
        throw new IllegalArgumentException("Cannot produce a relationship from " + object.getClass().getName());
    }

    public static LongValue asLongValue(Object object) {
        if (object instanceof LongValue) {
            return (LongValue)object;
        }
        if (object instanceof Long) {
            return Values.longValue((long)((Long)object));
        }
        throw new IllegalArgumentException("Cannot produce a long from " + object.getClass().getName());
    }

    public static DoubleValue asDoubleValue(Object object) {
        if (object instanceof DoubleValue) {
            return (DoubleValue)object;
        }
        if (object instanceof Double) {
            return Values.doubleValue((double)((Double)object));
        }
        throw new IllegalArgumentException("Cannot produce a double from " + object.getClass().getName());
    }

    public static BooleanValue asBooleanValue(Object object) {
        if (object instanceof BooleanValue) {
            return (BooleanValue)object;
        }
        if (object instanceof Boolean) {
            return Values.booleanValue((boolean)((Boolean)object));
        }
        throw new IllegalArgumentException("Cannot produce a boolean from " + object.getClass().getName());
    }

    public static TextValue asTextValue(Object object) {
        if (object instanceof TextValue) {
            return (TextValue)object;
        }
        if (object instanceof String) {
            return Values.stringValue((String)((String)object));
        }
        throw new IllegalArgumentException("Cannot produce a string from " + object.getClass().getName());
    }
}

