/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;

public abstract class TokenRecord
extends AbstractBaseRecord {
    private int nameId;
    private List<DynamicRecord> nameRecords;

    public TokenRecord(long id) {
        super(id);
    }

    public TokenRecord initialize(boolean inUse, int nameId) {
        super.initialize(inUse);
        this.nameId = nameId;
        this.nameRecords = new ArrayList<DynamicRecord>();
        return this;
    }

    @Override
    public void clear() {
        this.initialize(false, Record.NO_NEXT_BLOCK.intValue());
    }

    public boolean isLight() {
        return this.nameRecords == null || this.nameRecords.isEmpty();
    }

    public int getNameId() {
        return this.nameId;
    }

    public void setNameId(int blockId) {
        this.nameId = blockId;
    }

    public Collection<DynamicRecord> getNameRecords() {
        return this.nameRecords;
    }

    public void addNameRecord(DynamicRecord record) {
        this.nameRecords.add(record);
    }

    public void addNameRecords(Iterable<DynamicRecord> records) {
        for (DynamicRecord record : records) {
            this.addNameRecord(record);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.simpleName() + '[');
        buf.append(this.getId()).append(',').append(this.inUse() ? "in" : "no").append(" use");
        buf.append(",nameId=").append(this.nameId);
        this.additionalToString(buf);
        if (!this.isLight()) {
            for (DynamicRecord dyn : this.nameRecords) {
                buf.append(',').append(dyn);
            }
        }
        return buf.append(']').toString();
    }

    protected abstract String simpleName();

    protected void additionalToString(StringBuilder buf) {
    }

    @Override
    public TokenRecord clone() {
        TokenRecord clone = (TokenRecord)super.clone();
        clone.nameRecords = new ArrayList<DynamicRecord>(this.nameRecords.size());
        for (DynamicRecord record : this.nameRecords) {
            this.nameRecords.add(record.clone());
        }
        return clone;
    }
}

