/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class CopyOnWriteHashMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> actual = new HashMap();

    @Override
    public int size() {
        return this.actual.size();
    }

    @Override
    public boolean isEmpty() {
        return this.actual.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.actual.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.actual.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.actual.get(key);
    }

    private Map<K, V> copy() {
        return new HashMap<K, V>(this.actual);
    }

    public Map<K, V> snapshot() {
        return Collections.unmodifiableMap(this.actual);
    }

    @Override
    public synchronized V put(K key, V value) {
        Map<K, V> copy = this.copy();
        V previous = copy.put(key, value);
        this.actual = copy;
        return previous;
    }

    @Override
    public synchronized V remove(Object key) {
        Map<K, V> copy = this.copy();
        V previous = copy.remove(key);
        this.actual = copy;
        return previous;
    }

    @Override
    public synchronized void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        Map<? extends K, ? extends V> copy = this.copy();
        copy.putAll(m);
        this.actual = copy;
    }

    @Override
    public synchronized void clear() {
        this.actual = new HashMap();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public boolean remove(Object o) {
                return CopyOnWriteHashMap.this.remove(o) != null;
            }

            @Override
            @Nonnull
            public Iterator<K> iterator() {
                return new UnsupportedRemoveIterator(CopyOnWriteHashMap.this.actual.keySet().iterator());
            }

            @Override
            public int size() {
                return CopyOnWriteHashMap.this.actual.size();
            }
        };
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            @Nonnull
            public Iterator<V> iterator() {
                return new UnsupportedRemoveIterator(CopyOnWriteHashMap.this.actual.values().iterator());
            }

            @Override
            public int size() {
                return CopyOnWriteHashMap.this.actual.size();
            }
        };
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nonnull
            public Iterator<Map.Entry<K, V>> iterator() {
                return new UnsupportedRemoveIterator<Map.Entry<K, V>>(CopyOnWriteHashMap.this.actual.entrySet().iterator()){

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry actualNext = (Map.Entry)super.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return actualNext.getKey();
                            }

                            @Override
                            public V getValue() {
                                return actualNext.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public boolean equals(Object obj) {
                                return actualNext.equals(obj);
                            }

                            @Override
                            public int hashCode() {
                                return actualNext.hashCode();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return CopyOnWriteHashMap.this.actual.size();
            }
        };
    }

    private static class UnsupportedRemoveIterator<T>
    implements Iterator<T> {
        private final Iterator<T> actual;

        UnsupportedRemoveIterator(Iterator<T> actual) {
            this.actual = actual;
        }

        @Override
        public boolean hasNext() {
            return this.actual.hasNext();
        }

        @Override
        public T next() {
            return this.actual.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

