/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.id.RenewableBatchIdSequence;

public class RenewableBatchIdSequences
implements Resource {
    private final IdSequence[] types = new IdSequence[StoreType.values().length];

    public RenewableBatchIdSequences(NeoStores stores, int batchSize) {
        for (StoreType type : StoreType.values()) {
            if (!type.isRecordStore()) continue;
            RecordStore store = stores.getRecordStore(type);
            if (type.isLimitedIdStore() || batchSize == 1) {
                this.types[type.ordinal()] = store;
                continue;
            }
            this.types[type.ordinal()] = new RenewableBatchIdSequence(store, batchSize, store::freeId);
        }
    }

    public long nextId(StoreType type) {
        return this.idGenerator(type).nextId();
    }

    public IdSequence idGenerator(StoreType type) {
        return this.types[type.ordinal()];
    }

    public void close() {
        for (StoreType type : StoreType.values()) {
            IdSequence generator = this.idGenerator(type);
            if (!(generator instanceof RenewableBatchIdSequence)) continue;
            ((RenewableBatchIdSequence)generator).close();
        }
    }
}

