/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.neo4j.util.Preconditions;

public class ByteBufferFactory
implements AutoCloseable {
    private final Allocator globalAllocator;
    private final int threadLocalBufferSize;
    private final ThreadLocal<ThreadLocalByteBuffer> threadLocalBuffers = ThreadLocal.withInitial(() -> new ThreadLocalByteBuffer());
    private final Supplier<Allocator> allocatorFactory;
    static Allocator HEAP_ALLOCATOR = new Allocator(){

        @Override
        public ByteBuffer allocate(int bufferSize) {
            return ByteBuffer.allocate(Math.toIntExact(bufferSize));
        }

        @Override
        public void close() {
        }
    };

    public ByteBufferFactory(Supplier<Allocator> allocatorFactory, int threadLocalBufferSize) {
        this.allocatorFactory = allocatorFactory;
        this.globalAllocator = allocatorFactory.get();
        this.threadLocalBufferSize = threadLocalBufferSize;
    }

    Allocator globalAllocator() {
        return this.globalAllocator;
    }

    Allocator newLocalAllocator() {
        return this.allocatorFactory.get();
    }

    ByteBuffer acquireThreadLocalBuffer() {
        return this.threadLocalBuffers.get().acquire();
    }

    void releaseThreadLocalBuffer() {
        ThreadLocalByteBuffer managedByteBuffer = this.threadLocalBuffers.get();
        Preconditions.checkState((managedByteBuffer != null ? 1 : 0) != 0, (String)"Buffer doesn't exist");
        managedByteBuffer.release();
    }

    public int bufferSize() {
        return this.threadLocalBufferSize;
    }

    @Override
    public void close() {
        this.globalAllocator.close();
    }

    public static ByteBufferFactory heapBufferFactory(int sharedBuffersSize) {
        return new ByteBufferFactory(() -> HEAP_ALLOCATOR, sharedBuffersSize);
    }

    private class ThreadLocalByteBuffer {
        private boolean acquired;
        private ByteBuffer buffer;

        private ThreadLocalByteBuffer() {
        }

        ByteBuffer acquire() {
            Preconditions.checkState((!this.acquired ? 1 : 0) != 0, (String)"Already acquired");
            this.acquired = true;
            if (this.buffer == null) {
                this.buffer = ByteBufferFactory.this.globalAllocator.allocate(ByteBufferFactory.this.threadLocalBufferSize);
            } else {
                this.buffer.clear();
            }
            return this.buffer;
        }

        void release() {
            Preconditions.checkState((boolean)this.acquired, (String)"Not acquired");
            this.acquired = false;
        }
    }

    public static interface Allocator
    extends AutoCloseable {
        public ByteBuffer allocate(int var1);

        @Override
        public void close();
    }
}

