/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class IndexCreatorImpl
implements IndexCreator {
    private final Collection<String> propertyKeys;
    private final Label label;
    private final InternalSchemaActions actions;
    private final Optional<String> indexName;

    public IndexCreatorImpl(InternalSchemaActions actions, Label label) {
        this(actions, label, Optional.empty(), new ArrayList<String>());
    }

    private IndexCreatorImpl(InternalSchemaActions actions, Label label, Optional<String> indexName, Collection<String> propertyKeys) {
        this.actions = actions;
        this.label = label;
        this.indexName = indexName;
        this.propertyKeys = propertyKeys;
        this.assertInUnterminatedTransaction();
    }

    public IndexCreator on(String propertyKey) {
        this.assertInUnterminatedTransaction();
        return new IndexCreatorImpl(this.actions, this.label, this.indexName, this.copyAndAdd(this.propertyKeys, propertyKey));
    }

    public IndexCreator withName(String indexName) {
        this.assertInUnterminatedTransaction();
        return new IndexCreatorImpl(this.actions, this.label, Optional.ofNullable(indexName), this.propertyKeys);
    }

    public IndexDefinition create() throws ConstraintViolationException {
        this.assertInUnterminatedTransaction();
        if (this.propertyKeys.isEmpty()) {
            throw new ConstraintViolationException("An index needs at least one property key to index");
        }
        return this.actions.createIndexDefinition(this.label, this.indexName, this.propertyKeys.toArray(new String[0]));
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInOpenTransaction();
    }

    private Collection<String> copyAndAdd(Collection<String> propertyKeys, String propertyKey) {
        ArrayList<String> ret = new ArrayList<String>(propertyKeys);
        ret.add(propertyKey);
        return ret;
    }
}

