/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class KernelImpl
extends LifecycleAdapter
implements InwardKernel {
    private final KernelTransactions transactions;
    private final TransactionHooks hooks;
    private final DatabaseHealth health;
    private final TransactionMonitor transactionMonitor;
    private final Procedures procedures;
    private final Config config;
    private volatile boolean isRunning;

    public KernelImpl(KernelTransactions transactionFactory, TransactionHooks hooks, DatabaseHealth health, TransactionMonitor transactionMonitor, Procedures procedures, Config config) {
        this.transactions = transactionFactory;
        this.hooks = hooks;
        this.health = health;
        this.transactionMonitor = transactionMonitor;
        this.procedures = procedures;
        this.config = config;
    }

    public KernelTransaction beginTransaction(Transaction.Type type, LoginContext loginContext) throws TransactionFailureException {
        if (!this.isRunning) {
            throw new IllegalStateException("Kernel is not running, so it is not possible to use it");
        }
        return this.beginTransaction(type, loginContext, this.config.get(GraphDatabaseSettings.transaction_timeout).toMillis());
    }

    @Override
    public KernelTransaction beginTransaction(Transaction.Type type, LoginContext loginContext, long timeout) throws TransactionFailureException {
        this.health.assertHealthy(TransactionFailureException.class);
        KernelTransaction transaction = this.transactions.newInstance(type, loginContext, timeout);
        this.transactionMonitor.transactionStarted();
        return transaction;
    }

    @Override
    public void registerTransactionHook(TransactionHook hook) {
        this.hooks.register(hook);
    }

    @Override
    public void registerProcedure(CallableProcedure procedure) throws ProcedureException {
        this.procedures.register(procedure);
    }

    @Override
    public void registerUserFunction(CallableUserFunction function) throws ProcedureException {
        this.procedures.register(function);
    }

    @Override
    public void registerUserAggregationFunction(CallableUserAggregationFunction function) throws ProcedureException {
        this.procedures.register(function);
    }

    public void start() {
        this.isRunning = true;
    }

    public void stop() {
        if (!this.isRunning) {
            throw new IllegalStateException("kernel is not running, so it is not possible to stop it");
        }
        this.isRunning = false;
    }
}

