/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.annotations.ReporterFactory;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

abstract class NativeIndex<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements ConsistencyCheckable {
    final PageCache pageCache;
    final File storeFile;
    final IndexLayout<KEY, VALUE> layout;
    final FileSystemAbstraction fileSystem;
    final StoreIndexDescriptor descriptor;
    private final IndexProvider.Monitor monitor;
    private final boolean readOnly;
    protected GBPTree<KEY, VALUE> tree;

    NativeIndex(PageCache pageCache, FileSystemAbstraction fs, File storeFile, IndexLayout<KEY, VALUE> layout, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, boolean readOnly) {
        this.pageCache = pageCache;
        this.storeFile = storeFile;
        this.layout = layout;
        this.fileSystem = fs;
        this.descriptor = descriptor;
        this.monitor = monitor;
        this.readOnly = readOnly;
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Consumer<PageCursor> headerWriter) {
        this.ensureDirectoryExist();
        GBPTree.Monitor monitor = this.treeMonitor();
        this.tree = new GBPTree(this.pageCache, this.storeFile, this.layout, 0, monitor, GBPTree.NO_HEADER_READER, headerWriter, recoveryCleanupWorkCollector, this.readOnly);
        this.afterTreeInstantiation(this.tree);
    }

    protected void afterTreeInstantiation(GBPTree<KEY, VALUE> tree) {
    }

    private GBPTree.Monitor treeMonitor() {
        return new NativeIndexTreeMonitor();
    }

    private void ensureDirectoryExist() {
        try {
            this.fileSystem.mkdirs(this.storeFile.getParentFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void closeTree() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
        this.tree = null;
    }

    void assertOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Index has been closed");
        }
    }

    @Override
    public boolean consistencyCheck(ReporterFactory reporterFactory) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class));
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<KEY> visitor) {
        try {
            return this.tree.consistencyCheck(visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class NativeIndexTreeMonitor
    extends GBPTree.Monitor.Adaptor {
        private NativeIndexTreeMonitor() {
        }

        public void cleanupRegistered() {
            NativeIndex.this.monitor.recoveryCleanupRegistered(NativeIndex.this.storeFile, (IndexDescriptor)NativeIndex.this.descriptor);
        }

        public void cleanupStarted() {
            NativeIndex.this.monitor.recoveryCleanupStarted(NativeIndex.this.storeFile, (IndexDescriptor)NativeIndex.this.descriptor);
        }

        public void cleanupFinished(long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
            NativeIndex.this.monitor.recoveryCleanupFinished(NativeIndex.this.storeFile, (IndexDescriptor)NativeIndex.this.descriptor, numberOfPagesVisited, numberOfCleanedCrashPointers, durationMillis);
        }

        public void cleanupClosed() {
            NativeIndex.this.monitor.recoveryCleanupClosed(NativeIndex.this.storeFile, (IndexDescriptor)NativeIndex.this.descriptor);
        }

        public void cleanupFailed(Throwable throwable) {
            NativeIndex.this.monitor.recoveryCleanupFailed(NativeIndex.this.storeFile, (IndexDescriptor)NativeIndex.this.descriptor, throwable);
        }
    }
}

