/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;

public class CollectingIndexUpdater
implements IndexUpdater {
    private final Applier applier;
    private boolean closed;
    private final Collection<IndexEntryUpdate<?>> updates = new ArrayList();

    public CollectingIndexUpdater(Applier applier) {
        this.applier = applier;
    }

    @Override
    public void process(IndexEntryUpdate<?> update) {
        this.assertOpen();
        this.updates.add(update);
    }

    @Override
    public void close() throws IndexEntryConflictException {
        this.assertOpen();
        try {
            this.applier.accept(this.updates);
        }
        finally {
            this.closed = true;
        }
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Updater has been closed");
        }
    }

    public static interface Applier {
        public void accept(Collection<IndexEntryUpdate<?>> var1) throws IndexEntryConflictException;
    }
}

