/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.function.Supplier;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.AvailabilityGuard;

public class ThreadToStatementContextBridge
implements Supplier<Statement> {
    private final ThreadLocal<KernelTransaction> threadToTransactionMap = new ThreadLocal();
    private final AvailabilityGuard availabilityGuard;

    public ThreadToStatementContextBridge(AvailabilityGuard availabilityGuard) {
        this.availabilityGuard = availabilityGuard;
    }

    public boolean hasTransaction() {
        KernelTransaction kernelTransaction = this.threadToTransactionMap.get();
        if (kernelTransaction != null) {
            this.assertInUnterminatedTransaction(kernelTransaction);
            return true;
        }
        return false;
    }

    public void bindTransactionToCurrentThread(KernelTransaction transaction) {
        if (this.hasTransaction()) {
            throw new IllegalStateException(Thread.currentThread() + " already has a transaction bound");
        }
        this.threadToTransactionMap.set(transaction);
    }

    public void unbindTransactionFromCurrentThread() {
        this.threadToTransactionMap.remove();
    }

    @Override
    public Statement get() {
        return this.getKernelTransactionBoundToThisThread(true).acquireStatement();
    }

    public void assertInUnterminatedTransaction() {
        this.assertInUnterminatedTransaction(this.threadToTransactionMap.get());
    }

    public KernelTransaction getKernelTransactionBoundToThisThread(boolean strict) {
        KernelTransaction transaction = this.threadToTransactionMap.get();
        if (strict) {
            this.assertInUnterminatedTransaction(transaction);
        }
        return transaction;
    }

    private void assertInUnterminatedTransaction(KernelTransaction transaction) {
        if (this.availabilityGuard.isShutdown()) {
            throw new DatabaseShutdownException();
        }
        if (transaction == null) {
            throw new BridgeNotInTransactionException();
        }
        if (transaction.isTerminated()) {
            throw new TransactionTerminatedException((Status)transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated));
        }
    }

    private static class BridgeNotInTransactionException
    extends NotInTransactionException
    implements Status.HasStatus {
        private BridgeNotInTransactionException() {
        }

        public Status status() {
            return Status.Request.TransactionRequired;
        }
    }
}

