/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.function.BooleanSupplier;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.Format;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.tracing.CheckPointTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageEngine;

public class CheckPointerImpl
extends LifecycleAdapter
implements CheckPointer {
    private final TransactionAppender appender;
    private final TransactionIdStore transactionIdStore;
    private final CheckPointThreshold threshold;
    private final StorageEngine storageEngine;
    private final LogPruning logPruning;
    private final DatabaseHealth databaseHealth;
    private final IOLimiter ioLimiter;
    private final Log msgLog;
    private final CheckPointTracer tracer;
    private final StoreCopyCheckPointMutex mutex;
    private long lastCheckPointedTx;

    public CheckPointerImpl(TransactionIdStore transactionIdStore, CheckPointThreshold threshold, StorageEngine storageEngine, LogPruning logPruning, TransactionAppender appender, DatabaseHealth databaseHealth, LogProvider logProvider, CheckPointTracer tracer, IOLimiter ioLimiter, StoreCopyCheckPointMutex mutex) {
        this.appender = appender;
        this.transactionIdStore = transactionIdStore;
        this.threshold = threshold;
        this.storageEngine = storageEngine;
        this.logPruning = logPruning;
        this.databaseHealth = databaseHealth;
        this.ioLimiter = ioLimiter;
        this.msgLog = logProvider.getLog(CheckPointerImpl.class);
        this.tracer = tracer;
        this.mutex = mutex;
    }

    public void start() {
        this.threshold.initialize(this.transactionIdStore.getLastClosedTransactionId());
    }

    /*
     * Loose catch block
     */
    @Override
    public long forceCheckPoint(TriggerInfo info) throws IOException {
        this.ioLimiter.disableLimit();
        try {
            try (Resource lock = this.mutex.checkPoint();){
                long l = this.doCheckPoint(info);
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.ioLimiter.enableLimit();
        }
    }

    @Override
    public long tryCheckPoint(TriggerInfo info) throws IOException {
        return this.tryCheckPoint(info, () -> false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long tryCheckPoint(TriggerInfo info, BooleanSupplier timeout) throws IOException {
        this.ioLimiter.disableLimit();
        Resource lockAttempt = this.mutex.tryCheckPoint();
        if (lockAttempt != null) {
            try (Resource lock = lockAttempt;){
                long l = this.doCheckPoint(info);
                return l;
            }
        }
        Resource lock = this.mutex.tryCheckPoint(timeout);
        Throwable throwable = null;
        if (lock != null) {
            this.msgLog.info(info.describe(this.lastCheckPointedTx) + " Check pointing was already running, completed now");
            long l = this.lastCheckPointedTx;
            return l;
        }
        long l = -1L;
        return l;
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    lock.close();
                }
            }
        }
        finally {
            this.ioLimiter.enableLimit();
        }
    }

    @Override
    public long checkPointIfNeeded(TriggerInfo info) throws IOException {
        if (this.threshold.isCheckPointingNeeded(this.transactionIdStore.getLastClosedTransactionId(), info)) {
            try (Resource lock = this.mutex.checkPoint();){
                long l = this.doCheckPoint(info);
                return l;
            }
        }
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long doCheckPoint(TriggerInfo triggerInfo) throws IOException {
        try (LogCheckPointEvent event = this.tracer.beginCheckPoint();){
            long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
            long lastClosedTransactionId = lastClosedTransaction[0];
            LogPosition logPosition = new LogPosition(lastClosedTransaction[1], lastClosedTransaction[2]);
            String prefix = triggerInfo.describe(lastClosedTransactionId);
            this.databaseHealth.assertHealthy(IOException.class);
            this.msgLog.info(prefix + " checkpoint started...");
            long startTime = System.currentTimeMillis();
            this.storageEngine.flushAndForce(this.ioLimiter);
            this.databaseHealth.assertHealthy(IOException.class);
            this.appender.checkPoint(logPosition, event);
            this.threshold.checkPointHappened(lastClosedTransactionId);
            this.msgLog.info(prefix + " checkpoint completed in " + Format.duration(System.currentTimeMillis() - startTime));
            this.logPruning.pruneLogs(logPosition.getLogVersion());
            this.lastCheckPointedTx = lastClosedTransactionId;
            long l = lastClosedTransactionId;
            return l;
        }
        catch (Throwable t) {
            this.msgLog.error("Checkpoint failed", t);
            throw t;
        }
    }

    @Override
    public long lastCheckPointedTransactionId() {
        return this.lastCheckPointedTx;
    }
}

