/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.command.Command;

public class HighIdTransactionApplier
extends TransactionApplier.Adapter {
    private final NeoStores neoStores;
    private final Map<RecordStore<?>, HighId> highIds = new HashMap();

    public HighIdTransactionApplier(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        NodeStore nodeStore = this.neoStores.getNodeStore();
        this.track(nodeStore, command);
        this.track(nodeStore.getDynamicLabelStore(), ((NodeRecord)command.getAfter()).getDynamicLabelRecords());
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.track(this.neoStores.getRelationshipStore(), command);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        PropertyStore propertyStore = this.neoStores.getPropertyStore();
        this.track(propertyStore, command);
        for (PropertyBlock block : (PropertyRecord)command.getAfter()) {
            switch (block.getType()) {
                case STRING: {
                    this.track(propertyStore.getStringStore(), block.getValueRecords());
                    break;
                }
                case ARRAY: {
                    this.track(propertyStore.getArrayStore(), block.getValueRecords());
                    break;
                }
            }
        }
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) {
        this.track(this.neoStores.getRelationshipGroupStore(), command);
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) {
        this.trackToken(this.neoStores.getRelationshipTypeTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) {
        this.trackToken(this.neoStores.getLabelTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) {
        this.trackToken(this.neoStores.getPropertyKeyTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
        SchemaStore schemaStore = this.neoStores.getSchemaStore();
        for (DynamicRecord record : command.getRecordsAfter()) {
            this.track(schemaStore, record);
        }
        return false;
    }

    @Override
    public void close() {
        for (Map.Entry<RecordStore<?>, HighId> highId : this.highIds.entrySet()) {
            highId.getKey().setHighestPossibleIdInUse(highId.getValue().id);
        }
    }

    private void track(RecordStore<?> store, AbstractBaseRecord record) {
        long id = Math.max(record.getId(), record.requiresSecondaryUnit() ? record.getSecondaryUnitId() : -1L);
        HighId highId = this.highIds.get(store);
        if (highId == null) {
            this.highIds.put(store, new HighId(id));
        } else {
            highId.track(id);
        }
    }

    private <RECORD extends AbstractBaseRecord> void track(RecordStore<RECORD> store, Command.BaseCommand<RECORD> command) {
        this.track((RecordStore<?>)store, (AbstractBaseRecord)command.getAfter());
    }

    private void track(RecordStore<?> store, Collection<? extends AbstractBaseRecord> records) {
        for (AbstractBaseRecord abstractBaseRecord : records) {
            this.track(store, abstractBaseRecord);
        }
    }

    private <RECORD extends TokenRecord> void trackToken(TokenStore<RECORD> tokenStore, Command.TokenCommand<RECORD> tokenCommand) {
        this.track((RecordStore<?>)tokenStore, (AbstractBaseRecord)tokenCommand.getAfter());
        this.track(tokenStore.getNameStore(), ((TokenRecord)tokenCommand.getAfter()).getNameRecords());
    }

    private static class HighId {
        private long id;

        HighId(long id) {
            this.id = id;
        }

        void track(long id) {
            if (id > this.id) {
                this.id = id;
            }
        }
    }
}

