/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.procedure.TerminationGuard;

public class TerminationGuardProvider
implements ComponentRegistry.Provider<TerminationGuard> {
    public TerminationGuard apply(Context ctx) throws ProcedureException {
        KernelTransaction ktx = ctx.get(Context.KERNEL_TRANSACTION);
        return new TransactionTerminationGuard(ktx);
    }

    private class TransactionTerminationGuard
    implements TerminationGuard {
        private final KernelTransaction ktx;

        TransactionTerminationGuard(KernelTransaction ktx) {
            this.ktx = ktx;
        }

        public void check() {
            this.ktx.assertOpen();
        }
    }
}

