/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LayoutBootstrapper;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.labelscan.LabelScanLayout;
import org.neo4j.kernel.impl.index.schema.DateLayout;
import org.neo4j.kernel.impl.index.schema.DurationLayout;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.LocalTimeLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NumberLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.NumberLayoutUnique;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedTimeLayout;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsReader;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SchemaLayouts
implements LayoutBootstrapper {
    private final List<LayoutBootstrapper> allSchemaLayout = new ArrayList<LayoutBootstrapper>();

    public SchemaLayouts() {
        this.allSchemaLayout.addAll(Arrays.asList(SchemaLayouts.spatialLayoutFactory(CoordinateReferenceSystem.WGS84), SchemaLayouts.spatialLayoutFactory(CoordinateReferenceSystem.WGS84_3D), SchemaLayouts.spatialLayoutFactory(CoordinateReferenceSystem.Cartesian), SchemaLayouts.spatialLayoutFactory(CoordinateReferenceSystem.Cartesian_3D), (indexFile, pageCache, meta, targetLayout) -> new LocalTimeLayout(), (indexFile, pageCache, meta, targetLayout) -> new ZonedDateTimeLayout(), (indexFile, pageCache, meta, targetLayout) -> new DurationLayout(), (indexFile, pageCache, meta, targetLayout) -> new ZonedTimeLayout(), (indexFile, pageCache, meta, targetLayout) -> new DateLayout(), (indexFile, pageCache, meta, targetLayout) -> new LocalDateTimeLayout(), (indexFile, pageCache, meta, targetLayout) -> new StringLayout(), (indexFile, pageCache, meta, targetLayout) -> new NumberLayoutUnique(), (indexFile, pageCache, meta, targetLayout) -> new NumberLayoutNonUnique(), SchemaLayouts.genericLayout(), (indexFile, pageCache, meta, targetLayout) -> new LabelScanLayout()));
    }

    public Layout<?, ?> create(File indexFile, PageCache pageCache, Meta meta, String targetLayout) throws IOException {
        for (LayoutBootstrapper factory : this.allSchemaLayout) {
            Layout layout = factory.create(indexFile, pageCache, meta, targetLayout);
            if (layout == null || !SchemaLayouts.matchingLayout(meta, layout)) continue;
            return layout;
        }
        throw new RuntimeException("Layout with identifier \"" + targetLayout + "\" did not match meta " + meta);
    }

    private static boolean matchingLayout(Meta meta, Layout layout) {
        try {
            meta.verify(layout);
            return true;
        }
        catch (MetadataMismatchException e) {
            return false;
        }
    }

    private static LayoutBootstrapper genericLayout() {
        return (indexFile, pageCache, meta, targetLayout) -> {
            if (targetLayout.contains("generic")) {
                String numberOfSlotsString = targetLayout.replace("generic", "");
                int numberOfSlots = Integer.parseInt(numberOfSlotsString);
                HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
                GBPTree.readHeader((PageCache)pageCache, (File)indexFile, (Header.Reader)new NativeIndexHeaderReader(new SpaceFillingCurveSettingsReader(settings)));
                ConfiguredSpaceFillingCurveSettingsCache configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults());
                return new GenericLayout(numberOfSlots, new IndexSpecificSpaceFillingCurveSettingsCache(configuredSettings, settings));
            }
            return null;
        };
    }

    private static LayoutBootstrapper spatialLayoutFactory(CoordinateReferenceSystem crs) {
        return (indexFile, pageCache, meta, targetLayout) -> {
            if (targetLayout.equals(crs.getName())) {
                MutableBoolean failure = new MutableBoolean(false);
                Function<ByteBuffer, String> onError = byteBuffer -> {
                    failure.setTrue();
                    return "";
                };
                SpaceFillingCurveSettings curveSettings = SpaceFillingCurveSettingsFactory.fromGBPTree(indexFile, pageCache, onError);
                if (!failure.getValue().booleanValue()) {
                    return new SpatialLayout(crs, curveSettings.curve());
                }
            }
            return null;
        };
    }
}

