/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Comparator;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Values;

class PropertyLookupFallbackComparator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements Comparator<KEY> {
    private final IndexLayout<KEY, VALUE> schemaLayout;
    private final NodePropertyAccessor propertyAccessor;
    private final int propertyKeyId;

    PropertyLookupFallbackComparator(IndexLayout<KEY, VALUE> schemaLayout, NodePropertyAccessor propertyAccessor, int propertyKeyId) {
        this.schemaLayout = schemaLayout;
        this.propertyAccessor = propertyAccessor;
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    public int compare(KEY k1, KEY k2) {
        int comparison = this.schemaLayout.compareValue(k1, k2);
        if (comparison != 0) {
            return comparison;
        }
        try {
            return Values.COMPARATOR.compare(this.propertyAccessor.getNodePropertyValue(((NativeIndexKey)((Object)k1)).getEntityId(), this.propertyKeyId), this.propertyAccessor.getNodePropertyValue(((NativeIndexKey)((Object)k2)).getEntityId(), this.propertyKeyId));
        }
        catch (EntityNotFoundException e) {
            return comparison;
        }
    }
}

