/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.RawBits;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class NumberType
extends Type {
    NumberType(byte typeId) {
        super(ValueGroup.NUMBER, typeId, Values.of((Object)Double.NEGATIVE_INFINITY), Values.of((Object)Double.POSITIVE_INFINITY));
    }

    @Override
    int valueSize(GenericKey state) {
        return NumberType.numberKeySize(state.long1) + 1;
    }

    @Override
    void copyValue(GenericKey to, GenericKey from) {
        to.long0 = from.long0;
        to.long1 = from.long1;
    }

    @Override
    Value asValue(GenericKey state) {
        return NumberType.asValue(state.long0, state.long1);
    }

    @Override
    int compareValue(GenericKey left, GenericKey right) {
        return NumberType.compare(left.long0, left.long1, right.long0, right.long1);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        cursor.putByte((byte)state.long1);
        switch ((int)state.long1) {
            case 0: {
                cursor.putByte((byte)state.long0);
                break;
            }
            case 1: {
                cursor.putShort((short)state.long0);
                break;
            }
            case 2: 
            case 4: {
                cursor.putInt((int)state.long0);
                break;
            }
            case 3: 
            case 5: {
                cursor.putLong(state.long0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown number type " + state.long1);
            }
        }
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey into) {
        into.long1 = cursor.getByte();
        switch ((int)into.long1) {
            case 0: {
                into.long0 = cursor.getByte();
                return true;
            }
            case 1: {
                into.long0 = cursor.getShort();
                return true;
            }
            case 2: 
            case 4: {
                into.long0 = cursor.getInt();
                return true;
            }
            case 3: 
            case 5: {
                into.long0 = cursor.getLong();
                return true;
            }
        }
        return false;
    }

    static int numberKeySize(long long1) {
        switch ((int)long1) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unknown number type " + long1);
    }

    static NumberValue asValue(long long0, long long1) {
        return RawBits.asNumberValue(long0, (byte)long1);
    }

    static int compare(long this_long0, long this_long1, long that_long0, long that_long1) {
        return RawBits.compare(this_long0, (byte)this_long1, that_long0, (byte)that_long1);
    }

    void write(GenericKey state, long value, byte numberType) {
        state.long0 = value;
        state.long1 = numberType;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0=" + state.long0);
        joiner.add("long1=" + state.long1);
    }
}

