/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Supplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.coreapi.ExplicitIndexProxy;

public class RelationshipExplicitIndexProxy
extends ExplicitIndexProxy<Relationship>
implements RelationshipIndex {
    public RelationshipExplicitIndexProxy(String name, GraphDatabaseService gds, Supplier<KernelTransaction> txBridge) {
        super(name, RELATIONSHIP, gds, txBridge);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
        KernelTransaction ktx = (KernelTransaction)this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            RelationshipExplicitIndexCursor cursor = ktx.cursors().allocateRelationshipExplicitIndexCursor();
            long source = startNodeOrNull == null ? -1L : startNodeOrNull.getId();
            long target = endNodeOrNull == null ? -1L : endNodeOrNull.getId();
            ktx.indexRead().relationshipExplicitIndexLookup(cursor, this.name, key, valueOrNull, source, target);
            ExplicitIndexProxy.CursorWrappingRelationshipIndexHits cursorWrappingRelationshipIndexHits = new ExplicitIndexProxy.CursorWrappingRelationshipIndexHits(cursor, this.getGraphDatabase(), ktx, this.name);
            return cursorWrappingRelationshipIndexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
        KernelTransaction ktx = (KernelTransaction)this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            RelationshipExplicitIndexCursor cursor = ktx.cursors().allocateRelationshipExplicitIndexCursor();
            long source = startNodeOrNull == null ? -1L : startNodeOrNull.getId();
            long target = endNodeOrNull == null ? -1L : endNodeOrNull.getId();
            ktx.indexRead().relationshipExplicitIndexQuery(cursor, this.name, key, queryOrQueryObjectOrNull, source, target);
            ExplicitIndexProxy.CursorWrappingRelationshipIndexHits cursorWrappingRelationshipIndexHits = new ExplicitIndexProxy.CursorWrappingRelationshipIndexHits(cursor, this.getGraphDatabase(), ktx, this.name);
            return cursorWrappingRelationshipIndexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
        KernelTransaction ktx = (KernelTransaction)this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            RelationshipExplicitIndexCursor cursor = ktx.cursors().allocateRelationshipExplicitIndexCursor();
            long source = startNodeOrNull == null ? -1L : startNodeOrNull.getId();
            long target = endNodeOrNull == null ? -1L : endNodeOrNull.getId();
            ktx.indexRead().relationshipExplicitIndexQuery(cursor, this.name, queryOrQueryObjectOrNull, source, target);
            ExplicitIndexProxy.CursorWrappingRelationshipIndexHits cursorWrappingRelationshipIndexHits = new ExplicitIndexProxy.CursorWrappingRelationshipIndexHits(cursor, this.getGraphDatabase(), ktx, this.name);
            return cursorWrappingRelationshipIndexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }
}

