/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.lock.ResourceType;

public class MultiTokenSchemaDescriptor
implements SchemaDescriptor {
    private final int[] entityTokens;
    private final EntityType entityType;
    private final int[] propertyIds;

    MultiTokenSchemaDescriptor(int[] entityTokens, EntityType entityType, int[] propertyIds) {
        this.entityTokens = entityTokens;
        this.entityType = entityType;
        this.propertyIds = propertyIds;
    }

    public boolean isAffected(long[] entityTokenIds) {
        for (int id : this.entityTokens) {
            if (!ArrayUtils.contains((long[])entityTokenIds, (long)id)) continue;
            return true;
        }
        return false;
    }

    public <R> R computeWith(SchemaComputer<R> computer) {
        return (R)computer.computeSpecific((SchemaDescriptor)this);
    }

    public void processWith(SchemaProcessor processor) {
        processor.processSpecific((SchemaDescriptor)this);
    }

    public String toString() {
        return "MultiTokenSchemaDescriptor[" + this.userDescription(SchemaUtil.idTokenNameLookup) + "]";
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format(this.entityType + ":%s(%s)", String.join((CharSequence)", ", tokenNameLookup.entityTokensGetNames(this.entityType, this.entityTokens)), SchemaUtil.niceProperties((TokenNameLookup)tokenNameLookup, (int[])this.propertyIds));
    }

    public int[] getPropertyIds() {
        return this.propertyIds;
    }

    public int[] getEntityTokenIds() {
        return this.entityTokens;
    }

    public int keyId() {
        throw new UnsupportedOperationException(this + " does not have a single keyId.");
    }

    public ResourceType keyType() {
        return this.entityType == EntityType.NODE ? ResourceTypes.LABEL : ResourceTypes.RELATIONSHIP_TYPE;
    }

    public EntityType entityType() {
        return this.entityType;
    }

    public SchemaDescriptor.PropertySchemaType propertySchemaType() {
        return SchemaDescriptor.PropertySchemaType.PARTIAL_ANY_TOKEN;
    }

    public SchemaDescriptor schema() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaDescriptor)) {
            return false;
        }
        SchemaDescriptor that = (SchemaDescriptor)o;
        return Arrays.equals(this.entityTokens, that.getEntityTokenIds()) && this.entityType == that.entityType() && Arrays.equals(this.propertyIds, that.getPropertyIds());
    }

    public int hashCode() {
        int result = Objects.hash(this.entityType);
        result = 31 * result + Arrays.hashCode(this.entityTokens);
        result = 31 * result + Arrays.hashCode(this.propertyIds);
        return result;
    }
}

