/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class NodeSetFirstGroupStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private final int batchSize;
    private final ByteArray cache;
    private final NodeStore nodeStore;
    private final PageCursor nodeCursor;
    private NodeRecord[] current;
    private int cursor;

    NodeSetFirstGroupStep(StageControl control, Configuration config, NodeStore nodeStore, ByteArray cache) {
        super(control, "FIRST", config, 1, new StatsProvider[0]);
        this.cache = cache;
        this.batchSize = config.batchSize();
        this.nodeStore = nodeStore;
        this.nodeCursor = nodeStore.openPageCursorForReading(0L);
        this.newBatch();
    }

    @Override
    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees);
    }

    private void newBatch() {
        this.current = new NodeRecord[this.batchSize];
        this.cursor = 0;
    }

    @Override
    protected void process(RelationshipGroupRecord[] batch, BatchSender sender) {
        for (RelationshipGroupRecord group : batch) {
            long nodeId;
            if (!group.inUse() || this.cache.getByte(nodeId = group.getOwningNode(), 0) != 0) continue;
            this.cache.setByte(nodeId, 0, (byte)1);
            NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
            this.nodeStore.getRecordByCursor(nodeId, nodeRecord, RecordLoad.NORMAL, this.nodeCursor);
            nodeRecord.setNextRel(group.getId());
            nodeRecord.setDense(true);
            this.current[this.cursor++] = nodeRecord;
            if (this.cursor != this.batchSize) continue;
            sender.send(this.current);
            this.newBatch();
        }
        this.control.recycle(batch);
    }

    @Override
    protected void lastCallForEmittingOutstandingBatches(BatchSender sender) {
        if (this.cursor > 0) {
            sender.send(this.current);
        }
    }

    @Override
    public void close() throws Exception {
        this.nodeCursor.close();
        super.close();
    }
}

